import React, { useMemo, useState, useEffect, useCallback } from "react";
import Cookies from "js-cookie";
import dynamic from "next/dynamic";
import { useSelector, useDispatch } from "react-redux";
import useDynamicManager from "@/store/managers/useDynamicManager";
import ApiCall from "@/api/api-calls";

const SelectFormList = dynamic(() => import("./SelectFormList"), {
  ssr: false,
});

const FormList = ({ toggleModal, modalName, type }) => {
  const { state } = useDynamicManager(type);
  const token = Cookies.get("token");
  const [data, setData] = useState([]);
  const [page, setPage] = useState(1);
  const [pageSize, setPageSize] = useState(25);
  const [sortField, setSortfield] = useState("createdAt");
  const [sortDirection, setSortDirection] = useState("desc");
  const [searchTerm, setSearchTerm] = useState("");
  const [totalRecords, setTotalRecords] = useState(0);

  const [loading, setLoading] = useState(false);
  const dispatch = useDispatch();
  const currentPage = useSelector((state) => state.productData.currentPage);
  const query = `?page=${currentPage}&pageSize=${pageSize}&sortField=${sortField}&sortDirection=${sortDirection}&searchTerm=${searchTerm}`;

  const fetchData = async () => {
    setLoading(true);
    const res = await ApiCall.formEditor.search(query);
    const data = await res.json();
    setData(data);
    setTotalRecords(data.totalRecords);
    setLoading(false);
  };
  useEffect(() => {
    fetchData();
  }, []);

  useEffect(() => {
    fetchData();
  }, [searchTerm]);

  const tableSelectOptions = [
    {
      text: "Kiválasztás",
      type: "select",
      className: "rounded bg-blue-500/75 px-4 py-2 mr-4 text-white",
    },
  ];

  const columns = useMemo(
    () => [
      {
        id: "formTitle",
        name: "Form neve",
        selector: (row) => {
          return <p className="font-bold text-sm">{row.formTitle}</p>;
        },
        sortable: true,
        style: {
          overflow: "hidden",
          textOverflow: "ellipsis",
          whiteSpace: "normal", // Use "normal" to allow text to wrap within the cell
        },
      },
      {
        id: "createdAt",
        name: "Létrehozva",
        selector: (row) => row.createdAt,
        sortable: true,
      },
      {
        id: "updatedAt",
        name: "Frissítve",
        selector: (row) => row.updatedAt,
        sortable: true,
      },
    ],
    []
  );

  return (
    <div>
      {data && data.message && (
        <p className="bg-red-500 text-white p-5 text-base font-bold">
          {data.message}
        </p>
      )}

      {data && !data.message && (
        <SelectFormList
          tableTitle="Form lista"
          data={data}
          token={token}
          columns={columns}
          tableSelectOptionsList={tableSelectOptions}
          selectPath="form/select-form/"
          defaultSortFieldId="createdAt"
          paginationDefaultPage={currentPage}
          progressPending={loading}
          paginationTotalRows={totalRecords}
          paginationPerPage={pageSize}
          onSort={(sortId, direction) => {
            setSortfield(sortId.id);
            setSortDirection(direction);
          }}
          onSearch={setSearchTerm}
          // onChangePage={(page) => {
          //   setPage(page);
          //   pageStoreState ? dispatch(setCurrentPage({ page: page })) : 1;
          // }}
          onChangeRowsPerPage={(pageSize) => setPageSize(pageSize)}
          onFilterClear={() => fetchData()}
          showSelectFormModal={showSelectFormModal}
        />
      )}
    </div>
  );
};

export default FormList;
