import React, { useState, useRef } from "react";
import Button from "@/components/shared/button/Button";
import { useDispatch } from "react-redux";
import { updateGalleryImage } from "@/store/slices/pageEditorSlice";
import TabSwitcher from "@/components/shared/tabswitcher/TabSwitcher";
import "suneditor/dist/css/suneditor.min.css";
import ImageSettings from "./TabData/ImageSettings";
import TextSettings from "./TabData/TextSettings";
import TextContent from "./TabData/TextContent";
import SubTextContent from "./TabData/SubTextContent";

const EditGalleryImageOptions = ({
  editedImage,
  setEditedImage,
  showEditImageModal,
}) => {
  const [activeTab, setActiveTab] = useState(1);
  const [textContent, setTextContent] = useState(
    editedImage?.options?.textContent ? editedImage?.options?.textContent : ""
  );
  const [textContentColor, setTextContentColor] = useState(
    editedImage?.options?.textContentColor ?? "inherit"
  );
  const [subTextContent, setSubTextContent] = useState(
    editedImage?.options?.subTextContent ?? ""
  );
  const [subTextContentColor, setSubTextContentColor] = useState(
    editedImage?.options?.subTextContentColor ?? "inherit"
  );
  const [overlayColor, setOverlayColor] = useState(
    editedImage?.options?.overlayColor ?? "rgba(33, 33, 33, 0.5)"
  );
  const dispatch = useDispatch();

  const editImageRefs = useRef([]);
  let index = 0;

  const handleTabClick = (tabNumber) => {
    setActiveTab(tabNumber);
  };

  const addRef = (key, ref) => {
    if (ref) {
      editImageRefs.current[key] = ref; // Add or update the ref
    }
  };

  const tabData = [
    { id: 1, tabTitle: "Kép beállítások" },
    { id: 2, tabTitle: "Szöveg beállítások" },
    { id: 3, tabTitle: "Szöveges tartalom" },
    { id: 4, tabTitle: "Kiegésző szöveg" },
  ];
  const modifyGalleryImage = () => {
    const content = {
      textContent: textContent,
      subTextContent: subTextContent,
      textContentColor: textContentColor,
      subTextContentColor: subTextContentColor,
      overlayColor: overlayColor,
    };

    // Iterate through the keys of the ref object
    Object.entries(editImageRefs.current).forEach(([key, ref]) => {
      if (ref) {
        if (ref.props) {
          // Handle cases where props contain value data
          if (Array.isArray(ref.props.value)) {
            // Handle arrays of values
            content[key] = ref.props.value.map((item) => item.value);
          } else {
            // Handle single values
            content[key] = ref.props.value?.value ?? "";
          }
        } else {
          // Handle cases where ref itself holds value data
          content[key] = ref?.value ?? "";
        }
      }
    });

    // Dispatch the updated gallery image
    dispatch(
      updateGalleryImage({
        id: editedImage.image._id,
        image: editedImage.image,
        options: content,
      })
    );

    // Reset state and close modal
    setEditedImage({});
    showEditImageModal(false);
  };

  return (
    <div className="gallery-image-wrapper flex flex-col w-full p-4">
      {/* settings tabs */}
      <div className="w-full flex flex-row flex-nowrap border-b mb-4">
        <TabSwitcher
          data={tabData}
          activeTab={activeTab}
          onTabClick={handleTabClick}
        />
      </div>
      {/* image */}
      <div className={`w-full ${activeTab !== 1 ? "hidden" : ""}`}>
        {" "}
        <ImageSettings
          editedImage={editedImage}
          overlayColor={overlayColor}
          setOverlayColor={setOverlayColor}
          addRef={addRef}
        />
      </div>
      <div className={`w-full ${activeTab !== 2 ? "hidden" : ""}`}>
        {" "}
        <TextSettings
          editedImage={editedImage}
          overlayColor={overlayColor}
          setOverlayColor={setOverlayColor}
          addRef={addRef}
        />
      </div>
      <div className={`w-full ${activeTab !== 3 ? "hidden" : ""}`}>
        <TextContent
          editedImage={editedImage}
          addRef={addRef}
          textContentColor={textContentColor}
          setTextContentColor={setTextContentColor}
          textContent={textContent}
          setTextContent={setTextContent}
        />
      </div>
      <div className={`w-full ${activeTab !== 4 ? "hidden" : ""}`}>
        <SubTextContent
          editedImage={editedImage}
          addRef={addRef}
          subTextContent={subTextContent}
          setSubTextContent={setSubTextContent}
          subTextContentColor={subTextContentColor}
          setSubTextContentColor={setSubTextContentColor}
        />
      </div>

      <Button
        className="px-4 py-2 uppercase border bg-green-500/75 text-white hover:border-green-500 hover:bg-green-500 disabled:bg-gray-500 disabled:pointer-events-none"
        btntext="Mentés"
        onClick={modifyGalleryImage}
      />
    </div>
  );
};

export default EditGalleryImageOptions;
