import React, { useState, useCallback } from "react";
import useDynamicManager from "@/store/managers/useDynamicManager";
import { useModalManager } from "@/hooks/useModalManager";
import MediaGalleryModal from "@/components/media-store/GalleryModal/MediaGalleryModal";
import ApiCall from "@/api/api-calls";
import ImageWithFallback from "@/components/shared/image/ImageWithFallback";
import icons from "@/assets/icons/icons";
import ModalButton from "@/components/shared/modal/ModalButton";
import { useEditorGallery } from "@/hooks/useEditorGallery";
import Button from "@/components/shared/button/Button";
const EditorGallery = ({ toggleModal, modalName, type, lifecycleHandlers }) => {
  const [showGalleryModal, setShowGalleryModal] = useState(false);
  const {
    state,
    setSelectedGalleryImages,
    removeImageFromGallery,
    resetGalleryState,
    updateGalleryImageOrder,
    cloneGalleryImage,
  } = useDynamicManager(type);

  const {
    images,
    selectImageModal,
    editImageModal,
    editedImage,
    // Setters
    setSelectImageModal,
    setEditImageModal,
    setEditedImage,
    // Handlers
    handleEditSingleImage,
    handleRemoveSingleImage,
    handleCloneGalleryImage,
    handleUpdateGalleryImageOrder,
    handleGallerySubmit,
  } = useEditorGallery({ toggleModal, modalName, type });

  const handleSetSelectedGalleryImages = useCallback((images) => {
    const ret = [];
    images?.map((image) => ret.push({ image: image, options: {} }));
    setSelectedGalleryImages({ selectedImages: ret });
  }, []);
  return (
    <div className="relative h-max">
      <div className="slider-wrapper flex flex-row flex-nowrap w-full h-full">
        {/* Left side: list of selected images */}
        <div className="w-1/3 bg-gray-100 h-full flex flex-col p-4">
          <h5 className="text-normal text-gray-400 w-full font-bold">
            Kép lista:
          </h5>
          <div className="flex flex-col gap-4 overflow-y-auto max-h-[80vh] pr-1">
            {state.galleryImages.map((img, i) => (
              <div
                key={i}
                className="bg-white rounded-lg shadow-sm p-3 flex gap-4 items-start w-full">
                {/* Image thumbnail */}
                <div className="w-24 h-24 overflow-hidden rounded-md flex-shrink-0 border">
                  <ImageWithFallback
                    src={ApiCall.mediaStore.getResized(
                      "/2/2/0",
                      img?.image?.originalname
                    )}
                    width={96}
                    height={96}
                    alt={img?.image?.originalname ?? ""}
                    className="w-full h-full object-cover"
                    loading="lazy"
                    effect="blur"
                  />
                </div>

                {/* Details + actions */}
                <div className="flex flex-col justify-between flex-grow">
                  <p className="fill-gray-700 text-sm font-semibold truncate">
                    {i + 1}. {img?.image?.originalname}
                  </p>

                  <div className="flex justify-between items-center gap-2 mt-2 w-auto h-8">
                    {/* Clone */}
                    <button
                      title="Kép klónozása"
                      className="fill-green-500 hover:fill-green-700 w-full h-full cursor-pointer"
                      onClick={() => cloneGalleryImage({ selected: i })}>
                      {icons.clone}
                    </button>

                    {/* Move up */}
                    {i > 0 && (
                      <button
                        title="Mozgatás fel"
                        className="fill-gray-500 hover:fill-green-600 w-full h-full cursor-pointer"
                        onClick={() =>
                          updateGalleryImageOrder({ start: i - 1, end: i })
                        }>
                        {icons.up}
                      </button>
                    )}

                    {/* Move down */}
                    {i < state.galleryImages.length - 1 && (
                      <button
                        title="Mozgatás le"
                        className="fill-gray-500 hover:fill-green-600 w-full h-full cursor-pointer"
                        onClick={() =>
                          updateGalleryImageOrder({ start: i + 1, end: i })
                        }>
                        {icons.down}
                      </button>
                    )}

                    {/* Delete */}
                    <button
                      title="Kép törlése"
                      className="fill-red-500 hover:fill-red-700 w-full h-full cursor-pointer"
                      onClick={() =>
                        removeImageFromGallery({ id: img._id, index: i })
                      }>
                      {icons.trash}
                    </button>
                  </div>
                </div>
              </div>
            ))}
          </div>
        </div>

        {/* Right side: upload / select images */}
        <div className="w-2/3 h-full flex flex-col gap-6 border-l p-6 bg-white overflow-y-auto max-h-[90vh] rounded">
          <div className="border border-gray-200 rounded-lg p-4 shadow-sm bg-gray-50">
            <p className="text-lg font-semibold text-gray-700 mb-2">
              📤 Képfeltöltés
            </p>
            <div className="flex flex-row justify-between items-start gap-4">
              <div className="flex-1">
                <p className="text-sm text-gray-600 mb-2 font-medium">
                  Töltsön fel képet, vagy válasszon a médiatárból!
                </p>
              </div>
              <Button
                onClick={() => setShowGalleryModal(true)}
                className="border border-gray-300 px-4 py-2 text-gray-600 hover:border-gray-600 hover:text-gray-900"
                btntext="Kép(ek) kiválasztása"
              />
            </div>
          </div>
        </div>
      </div>

      {/* Save */}
      <ModalButton btntext="Mentés" callback={handleGallerySubmit} />
      <MediaGalleryModal
        isOpen={showGalleryModal}
        onClose={() => {
          setShowGalleryModal(false);
        }}
        action="productGallery"
        onConfirmSelection={(selectedImages) => {
          handleSetSelectedGalleryImages(selectedImages);
        }}
      />
    </div>
  );
};

export default EditorGallery;
