import React, { useRef, useEffect } from "react";
import LabeledInput from "@/components/shared/labeledinput/LabeledInput";
import TextInput from "@/components/shared/textinput/TextInput";
import { handleInputMinMax } from "@/utils/handleInputMinMax";
import useDynamicManager from "@/store/managers/useDynamicManager";

const ImageFilters = ({ addRef, type }) => {
  const inputRefs = useRef([]);
  const { state } = useDynamicManager(type);
  const content = state?.current?.content?.[0]?.content?.[0] ?? {};

  useEffect(() => {
    Object.entries(inputRefs.current).forEach(([key, ref]) => {
      addRef(key, ref);
    });
  });
  return (
    <div className="flex flex-col w-full my-4 pb-4">
      {" "}
      {/**********  filters *************/}
      <h3 className="font-bold">Filterek - csak haladó felhasználóknak</h3>
      {/* hue */}
      <LabeledInput
        label={"Hue:"}
        description={
          "Hue beállítása. 0-359-ig választható érték és az elforgatás fokát (deg) határozza meg. Alapértelmezett: 0"
        }>
        <TextInput
          type={"text"}
          name={"hue"}
          defaultValue={content?.hue ?? 0}
          onChange={(e) => handleInputMinMax(e)}
          min={0}
          max={359}
          ref={(r) => (inputRefs.current.hue = r)}
        />
      </LabeledInput>
      {/* saturation */}
      <LabeledInput
        label={"Szaturáció - Saturation:"}
        description={
          " Szaturáció beállítása. 0-200-ig választható érték. Alapértelmezett: 100"
        }>
        <TextInput
          type={"text"}
          name={"saturate"}
          defaultValue={content?.saturate ?? 100}
          onChange={(e) => handleInputMinMax(e)}
          min={0}
          max={200}
          ref={(r) => (inputRefs.current.saturate = r)}
        />
      </LabeledInput>
      {/* brightness */}
      <LabeledInput
        label={"Fényerő - Brightness:"}
        description={
          " Fényerő beállítása. 0-200-ig választható érték. Alapértelmezett: 100"
        }>
        <TextInput
          type={"text"}
          name={"brightness"}
          defaultValue={content?.brightness ?? 100}
          onChange={(e) => handleInputMinMax(e)}
          min={0}
          max={200}
          ref={(r) => (inputRefs.current.brightness = r)}
        />
      </LabeledInput>
      {/* contrast */}
      <LabeledInput
        label={"Kontraszt - Contrast:"}
        description={
          " Kontraszt beállítása. 0-200-ig választható érték. Alapértelmezett: 100"
        }>
        <TextInput
          type={"text"}
          name={"contrast"}
          defaultValue={content?.contrast ?? 100}
          onChange={(e) => handleInputMinMax(e)}
          min={0}
          max={200}
          ref={(r) => (inputRefs.current.contrast = r)}
        />
      </LabeledInput>
      {/* invert */}
      <LabeledInput
        label={"Invertálás - Invert:"}
        description={
          "Invertálás beállítása. 0-100-ig választható érték. Alapértelmezett: 0"
        }>
        <TextInput
          type={"text"}
          name={"invert"}
          defaultValue={content?.invert ?? 0}
          onChange={(e) => handleInputMinMax(e)}
          min={0}
          max={100}
          ref={(r) => (inputRefs.current.invert = r)}
        />
      </LabeledInput>
      {/* sepia */}
      <LabeledInput
        label={"Sepia:"}
        description={
          "Sepia beállítása. 0-100-ig választható érték. Alapértelmezett: 0"
        }>
        <TextInput
          type={"text"}
          name={"sepia"}
          defaultValue={content?.sepia ?? 0}
          onChange={(e) => handleInputMinMax(e)}
          min={0}
          max={100}
          ref={(r) => (inputRefs.current.sepia = r)}
        />
      </LabeledInput>
      {/* opacity */}
      <LabeledInput
        label={"Átlátszóság beállítása - Opacity:"}
        description={
          " Átlátszóság beállítása. 0-100-ig választható érték. Alapértelmezett: 100"
        }>
        <TextInput
          type={"text"}
          name={"opacity"}
          defaultValue={content?.opacity ?? 100}
          onChange={(e) => handleInputMinMax(e)}
          min={0}
          max={100}
          ref={(r) => (inputRefs.current.opacity = r)}
        />
      </LabeledInput>
      {/* blur */}
      <LabeledInput
        label={"Elmosás beállítása - Blur:"}
        description={
          "Elmosás beállítása. 0-100-ig választható érték. Alapértelmezett: 0"
        }>
        <TextInput
          type={"text"}
          name={"blur"}
          defaultValue={content?.blur ?? 0}
          onChange={(e) => handleInputMinMax(e)}
          min={0}
          max={100}
          ref={(r) => (inputRefs.current.blur = r)}
        />
      </LabeledInput>
    </div>
  );
};

export default ImageFilters;
