import React, { useState, useRef, useCallback } from "react";
// import MediaObject from "../../media-store/MediaObject/MediaObject";
import Image from "next/image";
import { findLastIndexOfChar } from "@/utils/findLastIndexOfChar";
import { useDispatch } from "react-redux";
import {
  selectedImage,
  clearSelectedImage,
} from "@/store/slices/pageEditorSlice";

const EditorImageSelect = ({ images, showSelectImageModal }) => {
  const dispatch = useDispatch();

  const handleImageSelect = useCallback((image) => {
    dispatch(
      selectedImage({
        selectedImage: image,
      })
    );
    showSelectImageModal(false);
  }, []);

  return (
    <div className="flex flex-row flex-wrap items-center justify-evenly">
      {images &&
        images?.map((l, i) => {
          switch (l?.props?.mimetype) {
            case "application/pdf":
              return (
                <div
                  className={`flex flex-col  mr-2 mb-2 items-center border-1`}
                  key={i}>
                  {/* <MediaObject
                    data={l}
                    index={i}
                    data-index={i}
                    className={"w-full"}
                    id={l._id}
                  /> */}
                  <p className="break-all p-1">{l?.props?.filename}</p>
                  <button onClick={() => handleImageSelect(l)}>
                    Kiválaszt
                  </button>
                </div>
              );
            default:
              return (
                <div
                  className={`flex flex-col  mr-2 mb-2 items-center border-1`}
                  key={i}>
                  <Image
                    src={
                      `${process.env.NEXT_PUBLIC_PATH}/api/admin/i/2/2/0/` +
                      findLastIndexOfChar.before(l?.originalname, ".") +
                      ".webp"
                    }
                    width={150}
                    height={100}
                    alt={l.originalname ?? ""}
                    effect="blur"
                    loading="lazy"
                  />
                  <p className="break-all p-1 text-sm">{l?.props?.filename}</p>
                  <button onClick={() => handleImageSelect(l)}>
                    Kiválaszt
                  </button>
                </div>
              );
          }
        })}
    </div>
  );
};

export default EditorImageSelect;
