import React, { useState, useRef } from "react";
import ApiCall from "@/api/api-calls";
import Button from "@/components/shared/button/Button";
import { initialData } from "@/data/data";
import dynamic from "next/dynamic";
import Image from "next/image";
import Select from "react-select";
import useDynamicManager from "@/store/managers/useDynamicManager";
import MediaGalleryModal from "@/components/media-store/GalleryModal/MediaGalleryModal";
const ColorPicker = dynamic(() => import("react-best-gradient-color-picker"), {
  ssr: false,
});
import icons from "@/assets/icons/icons";
import "suneditor/dist/css/suneditor.min.css";
const SunEditor = dynamic(() => import("suneditor-react"), {
  ssr: false,
});

const EditImageOptions = ({
  editedImage,
  setEditedImage,
  showEditImageModal,
  type,
}) => {
  const { state, updateSliderImage } = useDynamicManager(type);

  const [activeTab, setActiveTab] = useState(1);
  const [textContent, setTextContent] = useState(
    editedImage?.options?.textContent ? editedImage?.options?.textContent : ""
  );
  const [textContentColor, setTextContentColor] = useState(
    editedImage?.options?.textContentColor ?? "inherit"
  );
  const [subTextContent, setSubTextContent] = useState(
    editedImage?.options?.subTextContent ?? ""
  );
  const [subTextContentColor, setSubTextContentColor] = useState(
    editedImage?.options?.subTextContentColor ?? "inherit"
  );
  const [overlayColor, setOverlayColor] = useState(
    editedImage?.options?.overlayColor ?? "rgba(33, 33, 33, 0.5)"
  );

  const editImageRefs = useRef([]);

  let index = 0;
  const handleTabClick = (tabNumber) => {
    setActiveTab(tabNumber);
  };

  const modifyGalleryImage = () => {
    const content = {
      textContent: textContent,
      subTextContent: subTextContent,
      textContentColor: textContentColor,
      subTextContentColor: subTextContentColor,
      overlayColor: overlayColor,
    };

    editImageRefs.current.map((c, i) => {
      if (c) {
        if (c.props) {
          if (Array.isArray(c.props.value)) {
            content[c.props.name] = [];
            if (c?.props?.value?.length === 1) {
              content[c.props.name] = c.props.value[0].value;
            } else {
              c?.props?.value?.map((elem) => {
                content[c.props.name]?.push(elem.value);
              });
            }
          } else {
            content[c.props.name] = c.props.value.value;
          }
        } else {
          content[c.name] = c.value;
        }
      }
    });

    updateSliderImage({
      id: editedImage.image._id,
      image: editedImage.image,
      options: content,
    });

    setEditedImage({});
    showEditImageModal(false);
  };

  return (
    <div className="gallery-image-wrapper flex flex-col w-full p-4">
      {/* settings tabs */}
      <div className="w-full flex flex-row flex-nowrap border-b mb-4">
        <button
          onClick={() => handleTabClick(1)}
          className={`px-4 py-2 border-t border-l ${
            activeTab === 1 ? "active bg-green-500 text-white" : ""
          }`}>
          Kép beállítások
        </button>
        <button
          onClick={() => handleTabClick(2)}
          className={`px-4 py-2 border-t border-l ${
            activeTab === 2 ? "active bg-green-500 text-white" : ""
          }`}>
          Szöveg beállítások
        </button>
        <button
          onClick={() => handleTabClick(3)}
          className={`px-4 py-2 border-t border-l ${
            activeTab === 3 ? "active bg-green-500 text-white" : ""
          }`}>
          Szöveges tartalom
        </button>
        <button
          onClick={() => handleTabClick(4)}
          className={`px-4 py-2 border-t border-l border-r ${
            activeTab === 4 ? "active bg-green-500 text-white" : ""
          }`}>
          Kiegésző szöveg
        </button>
        {/* <button
          onClick={() => handleTabClick(5)}
          className={`px-4 py-2 border-t border-l border-r ${
            activeTab === 5 ? "active bg-green-500 text-white" : ""
          }`}>
          Link beállítások
        </button> */}
      </div>
      {/* image */}
      <div className={`w-full ${activeTab !== 1 ? "hidden" : ""}`}>
        <div
          className={`flex flex-col mr-2 mb-2 items-center border-1 w-full`}
          key={editedImage?.image?._id}>
          <Image
            src={ApiCall.mediaStore.getResizedImage(
              "/2/2/0/",
              editedImage?.image?.originalname
            )}
            width={150}
            height={100}
            alt={editedImage.image.originalname ?? ""}
            effect="blur"
            loading="lazy"
          />
          <p className="break-all p-1">{editedImage?.image?.props?.filename}</p>
        </div>
        {/* image layer */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"imageLayers"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Kép layer: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Megadhatja, hogy a kép fölött legyen-e egy layer.
              (alapértelmezett: Nincs layer a képen)
            </span>
          </label>

          <Select
            options={initialData?.editor?.image?.imageLayers}
            className="w-3/4"
            menuPosition={"fixed"}
            placeholder={"Válasszon layer megjelenítést"}
            backspaceRemovesValue={false}
            name={"imageLayers"}
            ref={(r) => (editImageRefs.current[index++] = r)}
            defaultValue={
              editedImage?.options?.imageLayers
                ? initialData?.editor?.image?.imageLayers.filter(
                    (x) => x.value === editedImage?.options?.imageLayers
                  )
                : initialData?.editor?.image?.imageLayers[0]
            }
            onChange={(val, e) => {
              // second parameter shows action triggered
              // dispatch(selectParentPage({ parent: val }));
            }}
            required
          />
        </div>
        {/* image layer color */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"imageOverlayColor"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Kép layer színe: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Válassza ki, hogy milyen színű legyen a kép előtti layer -
              (alapértelmezett érték:rgba(33, 33, 33, 0.5)).
            </span>
          </label>

          <ColorPicker value={overlayColor} onChange={setOverlayColor} />
        </div>
        {/* image url */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"imgUrl"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Kép link megadása: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Ha szeretné, hogy a képre kattintás más oldalra mutasson, adjon
              meg linket. A link megadása nem kötelező.
            </span>
          </label>

          <input
            type="text"
            name="imgUrl"
            id="imgUrl"
            ref={(r) => (editImageRefs.current[index++] = r)}
            defaultValue={editedImage?.options?.imgUrl ?? ""}
            className="w-3/4 border h-max p-2"
          />
        </div>
        {/* link target */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"imageTargets"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Link célpontja: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Ha megadott linket, ezen érték alapján nyílik a link célpontja.
              (alapértelmezett: Másik oldalt nyit a link)
            </span>
          </label>
          <Select
            options={initialData.editor.image.imageTargets}
            className="w-3/4"
            placeholder={"Válasszon link célt"}
            menuPosition={"fixed"}
            backspaceRemovesValue={false}
            name={"imageTargets"}
            ref={(r) => (editImageRefs.current[index++] = r)}
            defaultValue={
              editedImage?.options?.imageTargets
                ? initialData.editor.image.imageTargets.filter(
                    (x) => x.value === editedImage?.options?.imageTargets
                  )
                : initialData.editor.image.imageTargets[1]
            } // default selected
            onChange={(val, e) => {
              // second parameter shows action triggered
              // dispatch(selectParentPage({ parent: val }));
            }}
            required
          />
        </div>
        {/* alt text */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"altText"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">
              Képleírás - alt text - megadása:{" "}
            </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Adjon meg képleírást. Ez a szöveg csak a keresőrobotok és a
              szövegolvasó alkalmazások számára látható.
            </span>
          </label>
          <input
            type="text"
            name="altText"
            id="altText"
            ref={(r) => (editImageRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={editedImage?.options?.altText ?? ""}
          />
        </div>
        {/* link title */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"linkTitle"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">
              Kép link cím tulajdonságának megadása
            </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Adjon meg link cím tulajdonságot (link title). Ez a szöveg csak a
              keresőrobotok és a szövegolvasó alkalmazások számára látható.
            </span>
          </label>

          <input
            type="text"
            name="linkTitle"
            id="linkTitle"
            ref={(r) => (editImageRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={editedImage?.options?.linkTitle ?? ""}
          />
        </div>
      </div>
      {/* text settings */}
      <div className={`w-full ${activeTab !== 2 ? "hidden" : ""}`}>
        {/* slider content order */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"contentOrder"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Szöveg tartalom elrendezés: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Válassza ki, hogy sor vagy oszlop legyen a tartalmi elrendezés.
              (alapértelmezett: Oszlop)
            </span>
          </label>
          <Select
            options={initialData?.editor?.slider?.contentOrder}
            className="w-3/4"
            menuPosition={"fixed"}
            placeholder={
              "Válassza ki, hogy sor vagy oszlop legyen a tartalmi elrendezés."
            }
            backspaceRemovesValue={false}
            name={"contentOrder"}
            ref={(r) => (editImageRefs.current[index++] = r)}
            defaultValue={
              editedImage?.options?.contentOrder
                ? initialData?.editor?.slider?.contentOrder?.filter(
                    (x) => x.value === editedImage?.options?.contentOrder
                  )
                : initialData?.editor?.slider?.contentOrder[0]
            }
            onChange={(val, e) => {
              // second parameter shows action triggered
              // dispatch(selectParentPage({ parent: val }));
            }}
            required
          />
        </div>
        {/* swiper content position X axis */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"contentJustify"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">
              Tartalom elhelyezkedése X tengelyen:{" "}
            </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Válassza ki, hogy a konténeren belül milyen pozícióban
              helyezkedjenek el az elemek - (alapértelmezett érték: Center).
            </span>
          </label>

          <Select
            options={initialData.editor.slider.contentJustify}
            className="w-3/4"
            placeholder={"Tartalom elhelyezkedése X tengelyen"}
            backspaceRemovesValue={false}
            name={"contentJustify"}
            menuPosition={"fixed"}
            ref={(r) => (editImageRefs.current[index++] = r)}
            defaultValue={
              editedImage?.options?.contentJustify
                ? initialData.editor.slider.contentJustify.filter(
                    (x) => x.value === editedImage?.options?.contentJustify
                  )
                : initialData.editor.slider.contentJustify[0]
            }
            onChange={(val, e) => {
              // second parameter shows action triggered
              // dispatch(selectParentPage({ parent: val }));
            }}
            required
          />
        </div>
        {/* swiper content position Y axis */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"contentAlign"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">
              Tartalom elhelyezkedése Y tengelyen:{" "}
            </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Válassza ki, hogy a konténeren belül milyen pozícióban
              helyezkedjenek el az elemek - (alapértelmezett érték: Center).
            </span>
          </label>

          <Select
            options={initialData.editor.slider.contentAlign}
            className="w-3/4"
            placeholder={"Tartalom elhelyezkedése Y tengelyen"}
            backspaceRemovesValue={false}
            name={"contentAlign"}
            menuPosition={"fixed"}
            ref={(r) => (editImageRefs.current[index++] = r)}
            defaultValue={
              editedImage?.options?.contentAlign
                ? initialData.editor.slider.contentAlign.filter(
                    (x) => x.value === editedImage?.options?.contentAlign
                  )
                : initialData.editor.slider.contentAlign[1]
            }
            onChange={(val, e) => {
              // second parameter shows action triggered
              // dispatch(selectParentPage({ parent: val }));
            }}
            required
          />
        </div>
      </div>
      {/* textContent */}
      <div className={`w-full ${activeTab !== 3 ? "hidden" : ""}`}>
        {/* textContent */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"textContent"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap  pr-2">
            <p className="w-full font-bold">Szöveg: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Adjon meg tartalmat.
            </span>
          </label>
          <SunEditor
            lang="en"
            name="textContent"
            defaultValue={textContent}
            width="100%"
            height="100%"
            placeholder="Ide gépelheti a szöveget..."
            autoFocus={false}
            onChange={(value) => setTextContent(value)}
            setOptions={{
              buttonList: [
                [
                  "bold",
                  "underline",
                  "italic",
                  "strike",
                  "subscript",
                  "superscript",
                ],
                ["align", "list", "table"],
                ["undo", "redo"],
                ["removeFormat"],
                ["link", "image"],
                ["preview", "print"],
                ["fullScreen", "showBlocks", "codeView"],
              ],
              tableWidth: "100%",
              tableStyles: {
                border: "1px solid black",
              },
            }}
          />
        </div>
        {/* text size H1-H6 */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"textType"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Cím fontossága: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Válassza ki, hogy milyen fontosságú legyen a szöveg elem -
              (alapértelmezett érték: H1). A H1 elemet jellemzően csak az oldal
              tetején érdemes használni és egy oldalon csak egy H1 elem legyen.
            </span>
          </label>

          <Select
            options={initialData.editor.slider.textTypes}
            className="w-3/4 z-50"
            placeholder={"Válasszon cím fontosságot"}
            menuPosition={"fixed"}
            backspaceRemovesValue={false}
            name={"textType"}
            ref={(r) => (editImageRefs.current[index++] = r)}
            defaultValue={
              editedImage?.options?.textType
                ? initialData.editor.slider.textTypes.filter(
                    (x) => x.value === editedImage?.options?.textType
                  )
                : initialData.editor.slider.textTypes[0]
            }
            onChange={(val, e) => {
              // second parameter shows action triggered
              // dispatch(selectParentPage({ parent: val }));
            }}
            required
          />
        </div>
        {/* text alignment */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"textAlignment"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Szöveg pozíciója: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Válassza ki, hogy milyen pozícióban legyen a szöveg elem -
              (alapértelmezett érték: Balra zárt).
            </span>
          </label>

          <Select
            options={initialData.textAlignment}
            className="w-3/4"
            placeholder={"Válasszon szöveg pozíciót"}
            menuPosition={"fixed"}
            backspaceRemovesValue={false}
            name={"textAlignment"}
            ref={(r) => (editImageRefs.current[index++] = r)}
            defaultValue={
              editedImage?.options?.textAlignment
                ? initialData.textAlignment.filter(
                    (x) => x.value === editedImage?.options?.textAlignment
                  )
                : initialData.textAlignment[0]
            }
            onChange={(val, e) => {
              // second parameter shows action triggered
              // dispatch(selectParentPage({ parent: val }));
            }}
            required
          />
        </div>
        {/* textContent font family */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"textContentFontFamily"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Betűtípus: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Válassza ki, hogy milyen betűtípust használjon a szöveg elem -
              (alapértelmezett érték: Arial).
            </span>
          </label>

          <Select
            options={initialData.fontFamily}
            className="w-3/4"
            placeholder={"Válasszon betűtípust"}
            menuPosition={"fixed"}
            backspaceRemovesValue={false}
            name={"textContentFontFamily"}
            ref={(r) => (editImageRefs.current[index++] = r)}
            defaultValue={
              editedImage?.options?.textContentFontFamily
                ? initialData.fontFamily.filter(
                    (x) =>
                      x.value === editedImage?.options?.textContentFontFamily
                  )
                : initialData.fontFamily[0]
            }
            onChange={(val, e) => {
              // second parameter shows action triggered
              // dispatch(selectParentPage({ parent: val }));
            }}
            required
          />
        </div>
        {/* textContent animation */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"textAnimation"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Animáció: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Válassza ki az animáció típusát - (alapértelmezett érték: Slide in
              from left).
            </span>
          </label>

          <Select
            options={initialData?.animation}
            className="w-3/4"
            placeholder={"Válasszon animációt"}
            menuPosition={"fixed"}
            backspaceRemovesValue={false}
            name={"textAnimation"}
            ref={(r) => (editImageRefs.current[index++] = r)}
            defaultValue={
              editedImage?.options?.textAnimation
                ? initialData?.animation.filter(
                    (x) => x.value === editedImage?.options?.textAnimation
                  )
                : initialData?.animation[0]
            }
            onChange={(val, e) => {
              // second parameter shows action triggered
              // dispatch(selectParentPage({ parent: val }));
            }}
            required
          />
        </div>
        {/* textcontent animation delay */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"animationDelay"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">
              Szöveges tartalom animáció késleltetése:{" "}
            </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Megadhatja, hogy a szöveges elemnek mennyi legyen az animáció
              késleltetése. Alapértelmezett: 1s
            </span>
          </label>
          <div className="flex flex-row flex-nowrap justify-evenly items-center">
            <input
              type="text"
              name="animationDelay"
              id="animationDelay"
              ref={(r) => (editImageRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={editedImage?.options?.animationDelay ?? 1}
            />
          </div>
        </div>
        {/* textcontent animation duration */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"animationDuration"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">
              Szöveges tartalom animáció időtartama:{" "}
            </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Megadhatja, hogy a szöveges tartalom elemnek mennyi legyen az
              animáció időtartama. (pl.: 0.5, 2, 4) Alapértelmezett: 3s
            </span>
          </label>
          <div className="flex flex-row flex-nowrap justify-evenly items-center">
            <input
              type="text"
              name="animationDuration"
              id="animationDuration"
              ref={(r) => (editImageRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={editedImage?.options?.animationDuration ?? 3}
            />
          </div>
        </div>
        {/* textContent line height */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"textContentLineHeight"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Szöveg elem sortáv: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Adjon meg szöveg elem sortávot. Pl.: 28px vagy 1em, 2rem, stb.
            </span>
          </label>
          <input
            type="text"
            name="textContentLineHeight"
            id="textContentLineHeight"
            ref={(r) => (editImageRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={editedImage?.options?.textContentLineHeight ?? "28px"}
          />
        </div>
        {/* textContent letter spacing */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"textContentLetterSpacing"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Szöveg betűköz mérete: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Adjon meg szöveg elem betűköz méretet. Pl.: 28px vagy 1em, 2rem,
              stb.
            </span>
          </label>
          <input
            type="text"
            name="textContentLetterSpacing"
            id="textContentLetterSpacing"
            ref={(r) => (editImageRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={editedImage?.options?.textContentLetterSpacing ?? 0}
          />
        </div>
        {/* textcontent font size */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"textContentFontSize"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Szöveg mérete: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Megadhatja, hogy a szöveg elemnek mekkora legyen a mérete. Pl.:
              28px vagy 1em, 2rem, stb. Alapértelmezett: 0
            </span>
          </label>

          <input
            type="text"
            name="textContentFontSize"
            id="textContentFontSize"
            ref={(r) => (editImageRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={editedImage?.options?.textContentFontSize ?? 0}
          />
        </div>
        {/* textContent padding */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"textContentPadding"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Szöveg eltartás: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Megadhatja, hogy a szöveg elemnek mekkora eltartása legyen px-ben.
              Alapértelmezett: 0 0 0 0
            </span>
          </label>
          <>
            <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
              <span className="fill-gray-600 size-36">{icons.up}</span>
              <input
                type="text"
                name="textContentPaddingTop"
                id="textContentPaddingTop"
                ref={(r) => (editImageRefs.current[index++] = r)}
                className="w-3/4 border h-max p-2"
                defaultValue={editedImage?.options?.textContentPaddingTop ?? 0}
              />
            </div>
            <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
              <span className="fill-gray-600 size-36">{icons.right}</span>
              <input
                type="text"
                name="textContentPaddingRight"
                id="textContentPaddingRight"
                ref={(r) => (editImageRefs.current[index++] = r)}
                className="w-3/4 border h-max p-2"
                defaultValue={
                  editedImage?.options?.textContentPaddingRight ?? 0
                }
              />
            </div>
            <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
              <span className="fill-gray-600 size-36">{icons.down}</span>
              <input
                type="text"
                name="textContentPaddingBottom"
                id="textContentPaddingBottom"
                ref={(r) => (editImageRefs.current[index++] = r)}
                className="w-3/4 border h-max p-2"
                defaultValue={
                  editedImage?.options?.textContentPaddingBottom ?? 0
                }
              />
            </div>
            <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
              <span className="fill-gray-600 size-36">{icons.left}</span>
              <input
                type="text"
                name="textContentPaddingLeft"
                id="textContentPaddingLeft"
                ref={(r) => (editImageRefs.current[index++] = r)}
                className="w-3/4 border h-max p-2"
                defaultValue={editedImage?.options?.textContentPaddingLeft ?? 0}
              />
            </div>
          </>
        </div>
        {/* textcontent color */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"textContentColor"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">
              Fő szöveg betű színének beállítása:{" "}
            </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Megadhatja, hogy milyen színű legyen a fő szöveg. Alapértelmezett:
              #212121
            </span>
          </label>
          <div className="w-3/4 flex flex-row justify-center align-center">
            <ColorPicker
              value={textContentColor}
              onChange={setTextContentColor}
            />
          </div>
        </div>
      </div>
      {/* subtextContent */}
      <div className={`w-full ${activeTab !== 4 ? "hidden" : ""}`}>
        {/* subtextContent */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"subtextContent"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap  pr-2">
            <p className="w-full font-bold">Kiegészítő szöveg: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Adjon meg tartalmat.
            </span>
          </label>
          <SunEditor
            lang="en"
            name="subTextContent"
            defaultValue={subTextContent}
            width="100%"
            height="100%"
            placeholder="Ide gépelheti a szöveget..."
            autoFocus={false}
            onChange={(value) => setSubTextContent(value)}
            setOptions={{
              buttonList: [
                ["font", "fontSize", "formatBlock"],
                [
                  "bold",
                  "underline",
                  "italic",
                  "strike",
                  "subscript",
                  "superscript",
                ],
                ["align", "list", "table"],
                ["fontColor", "hiliteColor"],
                ["outdent", "indent"],
                ["undo", "redo"],
                ["removeFormat"],
                ["link", "image"],
                ["preview", "print"],
                ["fullScreen", "showBlocks", "codeView"],
              ],
              tableWidth: "100%",
              tableStyles: {
                border: "1px solid black",
              },
            }}
          />
        </div>
        {/* subtext alignment */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"subtextAlignment"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Szöveg pozíciója: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Válassza ki, hogy milyen pozícióban legyen a szöveg elem -
              (alapértelmezett érték: Balra zárt).
            </span>
          </label>

          <Select
            options={initialData.editor.slider.textAlignment}
            className="w-3/4"
            placeholder={"Válasszon szöveg pozíciót"}
            menuPosition={"fixed"}
            backspaceRemovesValue={false}
            name={"subtextAlignment"}
            ref={(r) => (editImageRefs.current[index++] = r)}
            defaultValue={
              editedImage?.options?.subtextAlignment
                ? initialData.editor.slider.textAlignment.filter(
                    (x) => x.value === editedImage?.options?.subtextAlignment
                  )
                : initialData.editor.slider.textAlignment[0]
            }
            onChange={(val, e) => {
              // second parameter shows action triggered
              // dispatch(selectParentPage({ parent: val }));
            }}
            required
          />
        </div>
        {/* subtextContent font family */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"subtextContentFontFamily"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Kiegészítő szöveg betűtípus: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Válassza ki, hogy milyen betűtípust használjon a kiegészítő szöveg
              elem - (alapértelmezett érték: Arial).
            </span>
          </label>

          <Select
            options={initialData.fontFamily}
            className="w-3/4"
            placeholder={"Válasszon betűtípust"}
            menuPosition={"fixed"}
            backspaceRemovesValue={false}
            name={"subtextContentFontFamily"}
            ref={(r) => (editImageRefs.current[index++] = r)}
            defaultValue={
              editedImage?.options?.subtextContentFontFamily
                ? initialData.fontFamily.filter(
                    (x) =>
                      x.value === editedImage?.options?.subtextContentFontFamily
                  )
                : initialData.fontFamily[0]
            }
            onChange={(val, e) => {
              // second parameter shows action triggered
              // dispatch(selectParentPage({ parent: val }));
            }}
            required
          />
        </div>
        {/* subtextContent animation */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"subtextAnimation"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Animáció: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Válassza ki az animáció típusát - (alapértelmezett érték: Nincs
              animáció).
            </span>
          </label>

          <Select
            options={initialData?.animation}
            className="w-3/4"
            placeholder={"Válasszon animációt"}
            menuPosition={"fixed"}
            backspaceRemovesValue={false}
            name={"subtextAnimation"}
            ref={(r) => (editImageRefs.current[index++] = r)}
            defaultValue={
              editedImage?.options?.subtextAnimation
                ? initialData?.animation.filter(
                    (x) => x.value === editedImage?.options?.subtextAnimation
                  )
                : initialData?.animation[0]
            }
            onChange={(val, e) => {
              // second parameter shows action triggered
              // dispatch(selectParentPage({ parent: val }));
            }}
            required
          />
        </div>
        {/* subtextContent animation delay */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"subtextAnimationDelay"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">
              Szöveges tartalom animáció késleltetése:{" "}
            </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Megadhatja, hogy a szöveges elemnek mennyi legyen az animáció
              késleltetése. Alapértelmezett: 1s
            </span>
          </label>
          <div className="flex flex-row flex-nowrap justify-evenly items-center">
            <input
              type="text"
              name="subtextAnimationDelay"
              id="subtextAnimationDelay"
              ref={(r) => (editImageRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={editedImage?.options?.subtextAnimationDelay ?? 1}
            />
          </div>
        </div>
        {/* subtextContent animation duration */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"subtextAnimationDuration"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">
              Szöveges tartalom animáció időtartama:{" "}
            </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Megadhatja, hogy a szöveges tartalom elemnek mennyi legyen az
              animáció időtartama. (pl.: 0.5, 2, 4) Alapértelmezett: 3s
            </span>
          </label>
          <div className="flex flex-row flex-nowrap justify-evenly items-center">
            <input
              type="text"
              name="subtextAnimationDuration"
              id="subtextAnimationDuration"
              ref={(r) => (editImageRefs.current[index++] = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={editedImage?.options?.subtextAnimationDuration ?? 3}
            />
          </div>
        </div>
        {/* subtextContent line height */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"subtextContentLineHeight"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Kiegészítő szöveg elem sortáv: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Adjon meg kiegészítő szöveg elem sortávot. Pl.: 28px vagy 1em,
              2rem, stb.
            </span>
          </label>
          <input
            type="text"
            name="subtextContentLineHeight"
            id="subtextContentLineHeight"
            ref={(r) => (editImageRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={
              editedImage?.options?.subtextContentLineHeight ?? "28px"
            }
          />
        </div>
        {/* subtextContent letter spacing */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"subtextContentLetterSpacing"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Szöveg betűköz mérete: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Adjon meg szöveg elem betűköz méretet. Pl.: 28px vagy 1em, 2rem,
              stb.
            </span>
          </label>
          <input
            type="text"
            name="subtextContentLetterSpacing"
            id="subtextContentLetterSpacing"
            ref={(r) => (editImageRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={
              editedImage?.options?.subtextContentLetterSpacing ?? 0
            }
          />
        </div>
        {/* subtextcontent font size */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"subtextContentFontSize"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Kiegészítő szöveg mérete: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Megadhatja, hogy a kiegészítő szöveg elemnek mekkora legyen a
              mérete. Pl.: 28px vagy 1em, 2rem, stb. Alapértelmezett: 0
            </span>
          </label>

          <input
            type="text"
            name="subtextContentFontSize"
            id="subtextContentFontSize"
            ref={(r) => (editImageRefs.current[index++] = r)}
            className="w-3/4 border h-max p-2"
            defaultValue={editedImage?.options?.subtextContentFontSize ?? 0}
          />
        </div>
        {/* subtextContent padding */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"subtextContentPadding"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Kiegészítő szöveg eltartás: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Megadhatja, hogy a kiegészítő szöveg elemnek mekkora eltartása
              legyen px-ben. Alapértelmezett: 0 0 0 0
            </span>
          </label>
          <>
            <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
              <span className="fill-gray-600 size-36">{icons.up}</span>
              <input
                type="text"
                name="subtextContentPaddingTop"
                id="subtextContentPaddingTop"
                ref={(r) => (editImageRefs.current[index++] = r)}
                className="w-3/4 border h-max p-2"
                defaultValue={
                  editedImage?.options?.subtextContentPaddingTop ?? 0
                }
              />
            </div>
            <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
              <span className="fill-gray-600 size-36">{icons.right}</span>
              <input
                type="text"
                name="subtextContentPaddingRight"
                id="subtextContentPaddingRight"
                ref={(r) => (editImageRefs.current[index++] = r)}
                className="w-3/4 border h-max p-2"
                defaultValue={
                  editedImage?.options?.subtextContentPaddingRight ?? 0
                }
              />
            </div>
            <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
              <span className="fill-gray-600 size-36">{icons.down}</span>
              <input
                type="text"
                name="subtextContentPaddingBottom"
                id="subtextContentPaddingBottom"
                ref={(r) => (editImageRefs.current[index++] = r)}
                className="w-3/4 border h-max p-2"
                defaultValue={
                  editedImage?.options?.subtextContentPaddingBottom ?? 0
                }
              />
            </div>
            <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
              <span className="fill-gray-600 size-36">{icons.left}</span>
              <input
                type="text"
                name="subtextContentPaddingLeft"
                id="subtextContentPaddingLeft"
                ref={(r) => (editImageRefs.current[index++] = r)}
                className="w-3/4 border h-max p-2"
                defaultValue={
                  editedImage?.options?.subtextContentPaddingLeft ?? 0
                }
              />
            </div>
          </>
        </div>
        {/* subtextContent color */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"subTextContentColor"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">
              Kiegészítő szöveg betű színének beállítása:{" "}
            </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Megadhatja, hogy milyen színű legyen a kiegészítő szöveg.
              Alapértelmezett: #212121
            </span>
          </label>
          <div className="w-3/4 flex flex-row justify-center align-center">
            <ColorPicker
              value={subTextContentColor}
              onChange={setSubTextContentColor}
            />
          </div>
        </div>
      </div>
      <div className={`w-full ${activeTab !== 5 ? "hidden" : ""}`}></div>
      <div>
        <Button
          className="px-4 py-2 uppercase border bg-green-500/75 text-white hover:border-green-500 hover:bg-green-500 disabled:bg-gray-500 disabled:pointer-events-none"
          btntext="Mentés"
          onClick={modifyGalleryImage}
        />
      </div>
    </div>
  );
};

export default EditImageOptions;
