import React from "react";
import Image from "next/image";
import icons from "@/assets/icons/icons";
import { findLastIndexOfChar } from "@/utils/findLastIndexOfChar";
import ControlButton from "@/components/shared/button/ControlButton";
import OrderControls from "@/components/shared/ordercontrol/OrderControls";
import ApiCall from "@/api/api-calls";
import ImageWithFallback from "@/components/shared/image/ImageWithFallback";

const SliderImageItem = ({
  image,
  index,
  onEdit,
  onClone,
  onOrderChange,
  onRemove,
  isFirst,
  isLast,
}) => {
  return (
    <div className="flex flex-row justify-start items-center w-full bg-white mb-2">
      {/* Index */}
      <div className="p-2 text-center font-bold w-1/6 h-full flex flex-row justify-center items-center">
        {index + 1}.
      </div>

      {/* Image */}
      <div className="flex flex-col justify-center items-center p-2 text-center w-4/6">
        <ImageWithFallback
          src={ApiCall.mediaStore.getResized(
            "/4/4/1",
            image?.image?.originalname
          )}
          width={200}
          height={100}
          alt={image?.image?.originalname ?? ""}
          style={{
            // width: "100%",
            // height: "auto",
            objectFit: "contain",
          }}
          loading="lazy"
        />
        <p>{image?.image?.originalname}</p>
      </div>

      {/* Controls */}
      <div className="flex flex-row flex-nowrap h-full text-center w-1/6">
        <div className="w-full h-full border p-2 cursor-pointer flex flex-col justify-between items-center">
          <ControlButton
            icon={icons.edit}
            color="green"
            onClick={() => onEdit(image)}
          />
          <ControlButton
            icon={icons.clone}
            color="green"
            onClick={() => onClone(index)}
          />
          <OrderControls
            index={index}
            isFirst={isFirst}
            isLast={isLast}
            onOrderChange={onOrderChange}
          />
          <ControlButton
            icon={icons.trash}
            color="red"
            onClick={() => onRemove(image, index)}
          />
        </div>
      </div>
    </div>
  );
};

export default SliderImageItem;
