import React, { useState, useCallback, useRef } from "react";
import { initialData } from "@/data/data";
import Button from "@/components/shared/button/Button";
import LabeledInput from "@/components/shared/labeledinput/LabeledInput";
import SelectInput from "@/components/shared/selectinput/SelectInput";
import ColorPickerComponent from "@/components/shared/colorpicker/ColorPickerComponent";
import { useEditorMainCategories } from "@/hooks/useEditorMainCategories";
import useDynamicManager from "@/store/managers/useDynamicManager";

const EditorMainCategories = ({ toggleModal, modalName, type }) => {
  const { state, selectedElement, addcurrentElementToColumn } =
    useDynamicManager(type);

  const editableContent = state.current.content || {};

  const [backgroundColor, setBackgroundColor] = useState(
    editableContent?.[0]?.content?.[0]?.backgroundColor ??
      "rgba(255, 255, 255, 1)"
  );

  const inputRefs = useRef([]);

  const submitMainProductCategory = useCallback(() => {
    const content = {
      type: "main-product-categories",
      title: "Fő termék kategóriák",
      backgroundColor: backgroundColor,
    };
    inputRefs.current.map((c, i) => {
      if (c) {
        if (c.props) {
          if (c.props.value?.[0]) {
            content[c.props.name] = c.props.value?.[0].value;
          } else {
            content[c.props.name] = c.props.value.value;
          }
        } else {
          content[c.name] = c.value;
        }
      }
    });
    selectedElement({
      content: content,
    });

    addcurrentElementToColumn();
    toggleModal(modalName);
    toggleModal("showSelectElementModal");
  }, [
    selectedElement,
    addcurrentElementToColumn,
    backgroundColor,
    inputRefs,
    modalName,
    toggleModal,
  ]);

  return (
    <div className="relative">
      <div className="main-product-categories--wrapper flex flex-col w-auto p-4">
        {/* Kategória sorrend */}
        <LabeledInput
          label="Termék kategória rendezés szempontja:"
          description="Válassza ki, hogy mi alapján legyenek rendezve a kategóriák -
              alapértelmezett (Termék kategória sorrend)">
          <SelectInput
            name="productCategoryOrder"
            options={initialData.productCategoryOrderBy}
            defaultValue={
              editableContent?.[0]?.content?.[0]?.productCategoryOrder
                ? initialData.productCategoryOrderBy.find(
                    (x) =>
                      x.value ===
                      editableContent?.[0]?.content?.[0]?.productCategoryOrder
                  )
                : initialData.productCategoryOrderBy[2]
            }
            placeholder="Termék kategória rendezés szempontja"
            ref={(r) => {
              inputRefs.current.productCategoryOrder = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* Kép megjelenítés */}
        <LabeledInput
          label="Termék kategória kép megjelenítés:"
          description="Válassza ki, hogy megjelenjenek-e képek a fő termék kategóriáknál
              - alapértelmezett (Igen)">
          <SelectInput
            name="productCategoryShowImage"
            options={initialData.bool}
            defaultValue={
              editableContent?.[0]?.content?.[0]?.productCategoryShowImage
                ? initialData.bool.find(
                    (x) =>
                      x.value ===
                      editableContent?.[0]?.content?.[0]
                        ?.productCategoryShowImage
                  )
                : initialData.bool[0]
            }
            placeholder="Termék kategória kép megjelenítés"
            ref={(r) => {
              inputRefs.current.productCategoryShowImage = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* category background color */}
        <LabeledInput
          label={"Háttér szín:"}
          description={
            "Válassza ki, hogy milyen színűek legyenek a kategória elemek hátterei - (alapértelmezett érték: rgba(255, 255, 255, 1) - Fehér)."
          }>
          <ColorPickerComponent
            name={"backgroundColor"}
            value={backgroundColor}
            onChange={setBackgroundColor}
          />
        </LabeledInput>
      </div>
      <div className="flex flex-row w-auto justify-end sticky bottom-0 bg-white p-2 border border-t">
        <Button
          onClick={submitMainProductCategory}
          className="px-4 py-2 uppercase border bg-green-500/75 text-white hover:border-green-500 hover:bg-green-500 disabled:bg-gray-500 disabled:pointer-events-none"
          btntext="Mentés"
          // disabled={!isValid}
        />
      </div>
    </div>
  );
};

export default EditorMainCategories;
