import React, { useEffect, useState, useCallback, useRef } from "react";
import { initialData } from "@/data/data";
import Button from "@/components/shared/button/Button";
import ApiCall from "@/api/api-calls";
import { useEditorProduct } from "@/hooks/useEditorProduct";
import LabeledInput from "@/components/shared/labeledinput/LabeledInput";
import SelectInput from "@/components/shared/selectinput/SelectInput";
import ColorPickerComponent from "@/components/shared/colorpicker/ColorPickerComponent";
import useDynamicManager from "@/store/managers/useDynamicManager";

const EditorProduct = ({ toggleModal, modalName, type }) => {
  const { state } = useDynamicManager(type);

  const { handleSubmitBlogData } = useEditorProduct({
    toggleModal,
    modalName,
    type: type,
  });
  const [isValid, setIsValid] = useState(false);
  const [categoryData, setCategoryData] = useState(null);
  const [color, setColor] = useState(
    state?.current?.content?.[0]?.content?.[0]?.backgroundColor ??
      "rgba(255, 255, 255, 1)"
  );

  useEffect(() => {
    const fetchCategoryData = async () => {
      const response = await ApiCall.productCategories.getAll();
      setCategoryData(response?.data);
    };
    fetchCategoryData();
  }, []);

  const inputRefs = useRef([]);

  useEffect(() => {
    // If there is data, the form is valid
    setIsValid(
      state?.current?.content?.[0]?.selectedColumn !== "" ? true : false
    );
  }, [state]);

  const submitProduct = useCallback(() => {
    handleSubmitBlogData(
      {
        type: "product",
        title: "Termékek",
        backgroundColor: color,
        displayedProperties: [],
      },
      inputRefs
    );
  }, [color, inputRefs]);

  return (
    <div className="relative">
      <div className="product-wrapper flex flex-col w-auto p-4">
        {/* Layout display type */}
        <LabeledInput
          label="Layout elrendezés típusa:"
          description="Válassza ki, hogy milyen elrendezésben jelenjen(ek) meg a
              termékbejegyzés(ek) - (alapértelmezett érték: Alap)">
          <SelectInput
            name="productLayoutSelect"
            options={initialData.layoutDisplay}
            defaultValue={
              state?.current?.content?.[0]?.productLayoutSelect
                ? initialData.layoutDisplay.find(
                    (x) =>
                      x.value ===
                      state?.current?.content?.[0]?.productLayoutSelect
                  )
                : initialData.layoutDisplay[2]
            }
            placeholder="Layout elrendezés típusa"
            ref={(r) => {
              inputRefs.current.productLayoutSelect = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* Layout select */}
        <LabeledInput
          label="Termék layout:"
          description="Válassza ki, hogy milyen formátumban jelenjen(ek) meg a
              termékbejegyzés(ek) - (alapértelmezett érték: Alap)">
          <SelectInput
            name="productSelect"
            options={initialData.productLayoutTypes}
            defaultValue={
              state?.current?.content?.[0]?.productSelect
                ? initialData.productLayoutTypes.find(
                    (x) =>
                      x.value === state?.current?.content?.[0]?.productSelect
                  )
                : initialData.productLayoutTypes[1]
            }
            placeholder="Válasszon termék bejegyzés megjelenítést"
            ref={(r) => {
              inputRefs.current.productSelect = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* product count per stack */}
        <LabeledInput
          label="Termékek oldalanként:"
          description="Válassza ki, az egyszerre megjelenítendő termékek számát
              (alapértelmezett érték: 4)">
          <SelectInput
            name="productLength"
            options={initialData.productLength}
            defaultValue={
              state?.current?.content?.[0]?.content?.[0]?.productLength
                ? initialData.productLength.find(
                    (x) =>
                      x.value ===
                      state?.current?.content?.[0]?.content?.[0]?.productLength
                  )
                : initialData.productLength[3]
            }
            placeholder="Termékek oldalanként"
            ref={(r) => {
              inputRefs.current.productLength = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* infiniteLoad */}
        <LabeledInput
          label="Termékek folyamatos töltése:"
          description="Válassza ki, hogy a kiválasztott termékek folyamatosan
              töltődjenek-e, amíg el nem fogynak (alapértelmezett érték: Igen)">
          <SelectInput
            name="infiniteLoad"
            options={initialData.bool}
            defaultValue={
              state?.current?.content?.[0]?.content?.[0]?.infiniteLoad
                ? initialData.bool.find(
                    (x) =>
                      x.value ===
                      state?.current?.content?.[0]?.content?.[0]?.infiniteLoad
                  )
                : initialData.bool[0]
            }
            placeholder="Termékek folyamatos töltése"
            ref={(r) => {
              inputRefs.current.infiniteLoad = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* order products by */}
        <LabeledInput
          label="Rendezés:"
          description="Válassza ki, hogy milyen érték alapján rendezve szeretné
              megjeleníteni a termékeket (alapértelmezett érték: Dátum)">
          <SelectInput
            name="orderBySelect"
            options={initialData.productsOrderBy}
            defaultValue={
              state?.current?.content?.[0]?.content?.[0]?.orderBySelect
                ? initialData.productsOrderBy.find(
                    (x) =>
                      x.value ===
                      state?.current?.content?.[0]?.content?.[0]?.orderBySelect
                  )
                : initialData.productsOrderBy[0]
            }
            placeholder="Rendezés"
            ref={(r) => {
              inputRefs.current.orderBySelect = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* Category select */}
        {categoryData && (
          <LabeledInput
            label="Megjelenítendő kategória kiválasztása:"
            description="Válassza ki, hogy kategóriába tartozó termékeket kíván
                megjeleníteni">
            <SelectInput
              name="selectedCategory"
              options={categoryData}
              defaultValue={
                state?.current?.content?.[0]?.content?.[0]?.selectedCategory
                  ? categoryData?.find(
                      (x) =>
                        x.value ===
                        state?.current?.content?.[0]?.content?.[0]
                          ?.selectedCategory
                    )
                  : categoryData?.[0]
              }
              placeholder="Megjelenítendő kategória kiválasztása"
              ref={(r) => {
                inputRefs.current.selectedCategory = r;
                // addRef("imageLayers", r); // Explicitly add/update ref
              }}
            />
          </LabeledInput>
        )}
        {/* Content display */}
        <LabeledInput
          label="Tartalom megjelenítése:"
          description="Válassza ki, hogy a termékeknél milyen tulajdonságokat szeretne
              megjeleníteni (alapértelmezett érték: Rövid szöveg)">
          <SelectInput
            name="displayedProperties"
            options={initialData.productDisplayedProperties}
            defaultValue={
              state?.current?.content?.[0]?.displayedProperties
                ? initialData.productDisplayedProperties?.find(
                    (x) =>
                      x.value ===
                      state?.current?.content?.[0]?.displayedProperties
                  )
                : initialData.productDisplayedProperties
            }
            placeholder="Tartalom megjelenítése"
            ref={(r) => {
              inputRefs.current.displayedProperties = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
            isMulti
          />
        </LabeledInput>
        {/* show tags */}
        <LabeledInput
          label="Címkék megjelenítése:"
          description="Válassza ki, hogy a bejegyzéseknél szeretné e megjeleníteni a
              bejegyzéshez tartozó címkéket (alapértelmezett érték: Igen)">
          <SelectInput
            name="showTags"
            options={initialData.bool}
            defaultValue={
              state?.current?.content?.[0]?.content?.[0]?.showTags
                ? initialData.bool?.find(
                    (x) =>
                      x.value ===
                      state?.current?.content?.[0]?.content?.[0]?.showTags
                  )
                : initialData.bool[0]
            }
            placeholder="Címkék megjelenítése"
            ref={(r) => {
              inputRefs.current.showTags = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* product background color */}
        <LabeledInput
          label={"Háttér szín:"}
          description={
            "Válassza ki, hogy milyen háttérszíne legyen a termék elemnek - (alapértelmezett érték: rgba(255, 255, 255, 1) - Fehér)."
          }>
          <ColorPickerComponent
            name={"backgroundColor"}
            value={color}
            onChange={setColor}
          />
        </LabeledInput>
      </div>
      <div className="flex flex-row w-auto justify-end sticky bottom-0 bg-white p-2 border border-t">
        <Button
          onClick={submitProduct}
          className="px-4 py-2 uppercase border bg-green-500/75 text-white hover:border-green-500 hover:bg-green-500 disabled:bg-gray-500 disabled:pointer-events-none"
          btntext="Mentés"
          // disabled={!isValid}
        />
      </div>
    </div>
  );
};
export default EditorProduct;
