import React, { useState } from "react";
import useDynamicManager from "@/store/managers/useDynamicManager";
import { useModalManager } from "@/hooks/useModalManager";
import MediaGalleryModal from "@/components/media-store/GalleryModal/MediaGalleryModal";
import ApiCall from "@/api/api-calls";
import ImageWithFallback from "@/components/shared/image/ImageWithFallback";
import icons from "@/assets/icons/icons";
import ModalButton from "@/components/shared/modal/ModalButton";

const EditorProductGallery = ({ setShowEditorGalleryModal, type }) => {
  const { toggleModal, isModalOpen } = useModalManager();
  const [showGalleryModal, setShowGalleryModal] = useState(false);
  const {
    state,
    setSelectedGalleryImages,
    removeImageFromGallery,
    resetGalleryState,
    updateGalleryImageOrder,
    cloneGalleryImage,
  } = useDynamicManager(type);

  return (
    <div className="relative h-max">
      <div className="slider-wrapper grid grid-cols-4 w-full">
        {/* Left side: list of selected images */}
        <div className="col-span-1 bg-gray-100 h-full p-4 ">
          <h5 className="text-normal text-gray-400 w-full font-bold">
            Kép lista:
          </h5>
          <div className="grid grid-cols-12 w-full gap-1 justify-center items-center h-[80vh] overflow-y-scroll">
            {state.galleryImages.map((img, i) => {
              return (
                <React.Fragment key={i}>
                  <div className="col-span-10 w-full">
                    <ImageWithFallback
                      src={ApiCall.mediaStore.getResized(
                        "/2/2/0",
                        img.originalname
                      )}
                      width={200}
                      height={200}
                      alt={img?.originalname ?? ""}
                      effect="blur"
                      loading="lazy"
                      className="col-span-9"
                    />
                    <p>
                      {i + 1}. <span>{img?.originalname}</span>
                    </p>
                  </div>
                  <div className="col-span-2 w-full h-full max-h-[14rem] bg-white flex flex-col justify-center items-center mr-1">
                    {/* <span
                  className="flex w-[2rem] h-[2rem] justify-center items-center fill-green-500/50 hover:fill-green-500 mb-4"
                  onClick={() => handleEditSingleImage(g)}>
                  {icons.edit}
                </span> */}
                    <span
                      className="flex w-[2rem] h-[2rem] justify-center items-center fill-green-500/50 hover:fill-green-500 mb-4"
                      onClick={() =>
                        cloneGalleryImage({
                          selected: i,
                        })
                      }>
                      {icons.clone}
                    </span>
                    {i === 0 && i < state.galleryImages?.length - 1 ? (
                      <span
                        className="flex w-[2rem] h-[2rem] justify-center items-center fill-gray-500/50 hover:fill-green-500 mb-4"
                        onClick={() =>
                          updateGalleryImageOrder({
                            start: i + 1,
                            end: i,
                          })
                        }>
                        {icons.down}
                      </span>
                    ) : i === 0 && i === state.galleryImages?.length - 1 ? (
                      <></>
                    ) : i !== 0 && i === state.galleryImages?.length - 1 ? (
                      <span
                        className="flex w-[2rem] h-[2rem] justify-center items-center fill-gray-500/50 hover:fill-green-500 mb-4"
                        onClick={() =>
                          updateGalleryImageOrder({
                            start: i - 1,
                            end: i,
                          })
                        }>
                        {icons.up}
                      </span>
                    ) : (
                      <>
                        <span
                          className="flex w-[2rem] h-[2rem] justify-center items-center fill-gray-500/50 hover:fill-green-500 mb-4"
                          onClick={() =>
                            updateGalleryImageOrder({
                              start: i - 1,
                              end: i,
                            })
                          }>
                          {icons.up}
                        </span>{" "}
                        <span
                          className="flex w-[2rem] h-[2rem] justify-center items-center fill-gray-500/50 hover:fill-green-500 mb-4"
                          onClick={() =>
                            updateGalleryImageOrder({
                              start: i + 1,
                              end: i,
                            })
                          }>
                          {icons.down}
                        </span>
                      </>
                    )}

                    <span
                      className="flex w-[2rem] h-[2rem] justify-center items-center fill-red-500/50 hover:fill-red-500  mb-4"
                      onClick={() =>
                        removeImageFromGallery({ id: img._id, index: i })
                      }>
                      {/* // removeImageFromGallery({ id: img._id, index: i })
                      }> */}{" "}
                      {icons.trash}
                    </span>
                  </div>
                </React.Fragment>
              );
            })}
          </div>
        </div>

        {/* Right side: upload / select images */}
        <div className="col-span-3 h-full flex flex-col border-l">
          <div className="flex flex-row w-full mb-4 p-4 border-b">
            <label
              htmlFor={"imageSelect"}
              className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
              <p className="w-full font-bold">Kép(ek) feltöltése: </p>
              <span className="w-full text-sm text-gray-600 whitespace-pre-line">
                Töltsön fel képet, vagy válasszon a médiatárból!
              </span>
            </label>
            <div className="flex flex-row w-3/4 justify-end items-center">
              <button
                onClick={() => setShowGalleryModal(true)}
                className="border border-gray-300 px-4 py-2 text-gray-500 hover:border-gray-600 hover:text-gray-900">
                Kép(ek) kiválasztása
              </button>
            </div>
          </div>
        </div>
      </div>

      {/* Save */}
      <ModalButton
        btntext="Mentés"
        callback={() => {
          setSelectedGalleryImages({
            selectedImages: state.galleryImages,
          });
          setShowEditorGalleryModal();
        }}
      />
      <MediaGalleryModal
        isOpen={showGalleryModal}
        onClose={() => setShowGalleryModal(false)}
        action="productGallery"
        onConfirmSelection={(selectedImage) => {
          setSelectedGalleryImages({ selectedImages: selectedImage });
        }}
      />
    </div>
  );
};

export default EditorProductGallery;
