import React from "react";
import Image from "next/image";
import icons from "@/assets/icons/icons";
import { findLastIndexOfChar } from "@/utils/findLastIndexOfChar";
import ControlButton from "@/components/shared/button/ControlButton";
import OrderControls from "@/components/shared/ordercontrol/OrderControls";

const GalleryImageItem = ({
  image,
  index,
  onEdit,
  onClone,
  onOrderChange,
  onRemove,
  isFirst,
  isLast,
}) => {
  const imageNameWithoutExt = findLastIndexOfChar.before(
    image?.image?.originalname,
    "."
  );
  return (
    <div className="flex flex-row justify-start items-center w-full bg-white mb-2">
      {/* Index */}
      <div className="p-2 text-center font-bold w-1/6 h-full flex flex-row justify-center items-center">
        {index + 1}.
      </div>

      {/* Image */}
      <div className="flex flex-col justify-center border p-2 text-center w-4/6">
        <Image
          src={`${process.env.NEXT_PUBLIC_PATH}/api/admin/i/2/2/0/${imageNameWithoutExt}.webp`}
          width={200}
          height={100}
          alt={image?.image?.originalname ?? ""}
          style={{
            width: "auto",
            height: "100%",
            objectFit: "contain",
          }}
          loading="lazy"
        />
        <p>{image?.image?.originalname}</p>
      </div>

      {/* Controls */}
      <div className="flex flex-row flex-nowrap h-full text-center w-1/6">
        <div className="w-full h-full border p-2 cursor-pointer flex flex-col justify-between items-center">
          <ControlButton
            icon={icons.edit}
            color="green"
            onClick={() => onEdit(image)}
          />
          <ControlButton
            icon={icons.clone}
            color="green"
            onClick={() => onClone(index)}
          />
          <OrderControls
            index={index}
            isFirst={isFirst}
            isLast={isLast}
            onOrderChange={onOrderChange}
          />
          <ControlButton
            icon={icons.trash}
            color="red"
            onClick={() => onRemove(image, index)}
          />
        </div>
      </div>
    </div>
  );
};

export default GalleryImageItem;
