import React, { useRef, useEffect } from "react";
import SelectInput from "@/components/shared/selectinput/SelectInput";
import { initialData } from "@/data/data";
import LabeledInput from "@/components/shared/labeledinput/LabeledInput";

const TextSettings = ({
  editedImage,
  overlayColor,
  setOverlayColor,
  addRef,
}) => {
  const textRefs = useRef([]);

  useEffect(() => {
    Object.entries(textRefs.current).forEach(([key, ref]) => {
      addRef(key, ref);
    });
  });
  return (
    <div className={`w-full`}>
      {/* content order */}
      <LabeledInput
        label="Szöveg tartalom elrendezés:"
        description=" Válassza ki, hogy sor vagy oszlop legyen a tartalmi elrendezés.
        (alapértelmezett: Oszlop)">
        <SelectInput
          name="contentOrder"
          options={initialData.contentOrder}
          defaultValue={
            editedImage?.options?.contentOrder
              ? initialData.contentOrder.find(
                  (x) => x.value === editedImage?.options?.contentOrder
                )
              : initialData.contentOrder[0]
          }
          placeholder="Válassza ki, hogy sor vagy oszlop legyen a tartalmi elrendezés."
          ref={(r) => {
            textRefs.current.contentOrder = r;
            addRef("contentOrder", r); // Explicitly add/update ref
          }}
        />
      </LabeledInput>

      {/* content position X axis */}
      <LabeledInput
        label="Tartalom elhelyezkedése X tengelyen:"
        description=" Válassza ki, hogy a konténeren belül milyen pozícióban
        helyezkedjenek el az elemek - (alapértelmezett érték: Center).">
        <SelectInput
          name="contentJustify"
          options={initialData.justify}
          defaultValue={
            editedImage?.options?.contentJustify
              ? initialData.justify.find(
                  (x) => x.value === editedImage?.options?.contentJustify
                )
              : initialData.justify[0]
          }
          placeholder="Tartalom elhelyezkedése X tengelyen"
          ref={(r) => (textRefs.current.contentJustify = r)}
        />
      </LabeledInput>

      {/* content position Y axis */}
      <LabeledInput
        label="Tartalom elhelyezkedése Y tengelyen:"
        description=" Válassza ki, hogy a konténeren belül milyen pozícióban
        helyezkedjenek el az elemek - (alapértelmezett érték: Center).">
        {" "}
        <SelectInput
          name="contentAlign"
          options={initialData.align}
          defaultValue={
            editedImage?.options?.contentAlign
              ? initialData.align.find(
                  (x) => x.value === editedImage?.options?.contentAlign
                )
              : initialData.align[0]
          }
          placeholder="Tartalom elhelyezkedése Y tengelyen"
          ref={(r) => (textRefs.current.contentAlign = r)}
        />
      </LabeledInput>
    </div>
  );
};

export default TextSettings;
