import React, { useEffect, useState, useCallback, useRef } from "react";
import { initialData } from "@/data/data";
import Button from "@/components/shared/button/Button";
import Modal from "@/components/shared/modal/Modal";
import ArticleList from "./ArticleList";
import { useEditorSingleArticle } from "@/hooks/useEditorSingleArticle";
import LabeledInput from "@/components/shared/labeledinput/LabeledInput";
import SelectInput from "@/components/shared/selectinput/SelectInput";
import ColorPickerComponent from "@/components/shared/colorpicker/ColorPickerComponent";

const EditorSingleArticle = ({ toggleModal, modalName }) => {
  const {
    selectedArticle,
    editableContent,
    handleSelectSingleArticle,
    handleSubmitSingleArticle,
  } = useEditorSingleArticle({
    toggleModal,
    modalName,
  });
  const [selectArticleModal, showSelectArticleModal] = useState(false);
  const [color, setColor] = useState(
    editableContent?.[0]?.content?.[0]?.backgroundColor ??
      "rgba(255, 255, 255, 1)"
  );
  const inputRefs = useRef([]);

  useEffect(() => {
    handleSelectSingleArticle();
  }, [editableContent, handleSelectSingleArticle]);

  const generateSelectedArticle = () => {
    const articleId = selectedArticle?._id;
    const articleTitle = selectedArticle?.articleTitle;

    if (!articleId || !articleTitle) {
      return (
        <div className="flex flex-col justify-center items-center">
          <h5>No article selected.</h5>
        </div>
      );
    }

    return (
      <div className="w-full flex flex-col justify-center items-center">
        <h5>
          <span className="font-semibold">Azonosító:</span> {articleId}
        </h5>
        <h5>
          <span className="font-semibold">Cikk címe:</span> {articleTitle}
        </h5>
      </div>
    );
  };
  const submitArticle = useCallback(() => {
    handleSubmitSingleArticle(
      {
        type: "single-article",
        title: "Egy cikk",
        backgroundColor: color,
        displayedProperties: [],
        selectedArticle: selectedArticle,
      },
      inputRefs
    );
  }, [color, selectedArticle, inputRefs]);

  return (
    <div className="relative">
      <div className="single-product-wrapper flex flex-col w-auto p-4">
        {/* select product */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"articleSelect"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Cikk kiválasztása: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Válasszon ki egy cikket!
            </span>
          </label>
          <div className="flex flex-row w-3/4 justify-end items-center">
            {generateSelectedArticle()}
          </div>
          <div className="flex flex-row w-max justify-end items-center">
            <Button
              onClick={() => showSelectArticleModal(true)}
              className=" border border-gray-300 px-4 py-2 text-gray-500 hover:border-gray-600 hover:text-gray-900"
              btntext="Cikk kiválasztása"></Button>
          </div>
        </div>
        {/* Layout select */}
        <LabeledInput
          label="Cikk layout:"
          description="Válassza ki, hogy milyen formátumban jelenjen meg a cikk -
              (alapértelmezett érték: Alap)">
          <SelectInput
            name="articleSelect"
            options={initialData.bloglayoutTypes}
            defaultValue={
              editableContent?.[0]?.content?.[0]?.articleSelect
                ? initialData.bloglayoutTypes.find(
                    (x) =>
                      x.value ===
                      editableContent?.[0]?.content?.[0]?.articleSelect
                  )
                : initialData.bloglayoutTypes[2]
            }
            placeholder="Cikk layout"
            ref={(r) => {
              inputRefs.current.articleSelect = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* show tags */}
        <LabeledInput
          label="Címkék megjelenítése:"
          description="Válassza ki, hogy a bejegyzéseknél szeretné e megjeleníteni a
              bejegyzéshez tartozó címkéket (alapértelmezett érték: Igen)">
          <SelectInput
            name="showTags"
            options={initialData.bool}
            defaultValue={
              editableContent?.[0]?.content?.[0]?.showTags
                ? initialData.bool.find(
                    (x) =>
                      x.value === editableContent?.[0]?.content?.[0]?.showTags
                  )
                : initialData.bool[0]
            }
            placeholder="Címkék megjelenítése"
            ref={(r) => {
              inputRefs.current.showTags = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* article background color */}
        <LabeledInput
          label={"Háttér szín:"}
          description={
            "Válassza ki, hogy milyen színűek legyenek a cikk háttere - (alapértelmezett érték: rgba(255, 255, 255, 1) - Fehér)."
          }>
          <ColorPickerComponent
            name={"backgroundColor"}
            value={color}
            onChange={setColor}
          />
        </LabeledInput>
      </div>
      <div className="flex flex-row w-auto justify-end sticky bottom-0 bg-white p-2 border border-t">
        <Button
          onClick={submitArticle}
          className="px-4 py-2 uppercase border bg-green-500/75 text-white hover:border-green-500 hover:bg-green-500 disabled:bg-gray-500 disabled:pointer-events-none"
          btntext="Mentés"
          // disabled={!isValid}
        />
      </div>
      <Modal
        title={"Cikklista"}
        show={selectArticleModal}
        onClose={() => showSelectArticleModal(false)}
        height={"100%"}>
        <ArticleList showSelectArticleModal={showSelectArticleModal} />
      </Modal>
    </div>
  );
};

export default EditorSingleArticle;
