import React, { useEffect, useState, useCallback, useRef } from "react";
import { initialData } from "@/data/data";
import Button from "@/components/shared/button/Button";
import Modal from "@/components/shared/modal/Modal";
import ProductList from "./ProductList";
import { useEditorSingleProduct } from "@/hooks/useEditorSingleProduct";
import LabeledInput from "@/components/shared/labeledinput/LabeledInput";
import SelectInput from "@/components/shared/selectinput/SelectInput";
import ColorPickerComponent from "@/components/shared/colorpicker/ColorPickerComponent";
import useDynamicManager from "@/store/managers/useDynamicManager";

const EditorSingleProduct = ({ toggleModal, modalName, type }) => {
  const { state } = useDynamicManager(type);
  const { handleSubmitSingleProduct } = useEditorSingleProduct({
    toggleModal,
    modalName,
    type: type,
  });
  const [selectProductModal, showSelectProductModal] = useState(false);
  const inputRefs = useRef([]);
  const [color, setColor] = useState(
    state?.current?.content?.[0]?.backgroundColor ?? "rgba(255, 255, 255, 1)"
  );

  const generateSelectedProduct = useCallback(() => {
    if (state) {
      const productId =
        state?.selectedProduct?._id ??
        state?.current?.content?.[0]?.content?.[0]?.selectedProduct?._id;

      const productTitle =
        state?.selectedProduct?.productGroupTitle ??
        state?.current?.content?.[0]?.content?.[0]?.selectedProduct
          ?.productGroupTitle;

      if (!productId || !productTitle) {
        return (
          <div className="flex flex-col justify-center items-center">
            <h5>Nincs kiválasztva termék.</h5>
          </div>
        );
      }

      return (
        <div className="w-full flex flex-col justify-center items-center">
          <h5>
            <span className="font-semibold">Azonosító:</span> {productId}
          </h5>
          <h5>
            <span className="font-semibold">Termék neve:</span> {productTitle}
          </h5>
        </div>
      );
    }
  }, [state]);

  const submitProduct = useCallback(() => {
    handleSubmitSingleProduct(
      {
        type: "single-product",
        title: "Egy termék",
        backgroundColor: color,
        displayedProperties: [],
        selectedProduct: state?.selectedProduct,
      },
      inputRefs
    );
  }, [color, state, inputRefs]);

  return (
    <div className="relative">
      <div className="single-product-wrapper flex flex-col w-auto p-4">
        {/* select product */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor={"productSelect"}
            className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
            <p className="w-full font-bold">Termék kiválasztása: </p>
            <span className="w-full text-sm text-gray-600 whitespace-pre-line">
              Válasszon ki egy terméket!
            </span>
          </label>
          <div className="flex flex-row w-3/4 justify-end items-center">
            {generateSelectedProduct()}
          </div>
          <div className="flex flex-row w-3/4 justify-end items-center">
            <Button
              onClick={() => showSelectProductModal(true)}
              className=" border border-gray-300 px-4 py-2 text-gray-500 hover:border-gray-600 hover:text-gray-900"
              btntext="Termék kiválasztása"></Button>
          </div>
        </div>
        {/* Layout select */}
        <LabeledInput
          label="Termék layout:"
          description="Válassza ki, hogy milyen formátumban jelenjen meg a cikk -
              (alapértelmezett érték: Alap)">
          <SelectInput
            name="productSelect"
            options={initialData.productLayoutTypes}
            defaultValue={
              state?.current?.content?.[0]?.content?.[0]?.productSelect
                ? initialData.productLayoutTypes.find(
                    (x) =>
                      x.value ===
                      state?.current?.content?.[0]?.content?.[0]?.productSelect
                  )
                : initialData.productLayoutTypes[1]
            }
            placeholder="Termék layout"
            ref={(r) => {
              inputRefs.current.productSelect = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* Content display */}
        <LabeledInput
          label="Tartalom megjelenítése:"
          description="Válassza ki, hogy a termékeknél milyen tulajdonságokat szeretne
              megjeleníteni (alapértelmezett érték: Rövid szöveg)">
          <SelectInput
            name="displayedProperties"
            options={initialData.productDisplayedProperties}
            defaultValue={
              state?.current?.content?.[0]?.content?.[0]?.displayedProperties
                ? initialData.productDisplayedProperties.find(
                    (x) =>
                      x.value ===
                      state?.current?.content?.[0]?.content?.[0]
                        ?.displayedProperties
                  )
                : initialData.productDisplayedProperties[2]
            }
            placeholder="Tartalom megjelenítése"
            ref={(r) => {
              inputRefs.current.displayedProperties = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* show tags */}
        <LabeledInput
          label="Címkék megjelenítése:"
          description="Válassza ki, hogy a terméknél szeretné e megjeleníteni a hozzá
              tartozó címkéket (alapértelmezett érték: Igen)">
          <SelectInput
            name="showTags"
            options={initialData.bool}
            defaultValue={
              state?.current?.content?.[0]?.content?.[0]?.showTags
                ? initialData.bool.find(
                    (x) =>
                      x.value ===
                      state?.current?.content?.[0]?.content?.[0]?.showTags
                  )
                : initialData.bool[1]
            }
            placeholder="Címkék megjelenítése"
            ref={(r) => {
              inputRefs.current.showTags = r;
              // addRef("imageLayers", r); // Explicitly add/update ref
            }}
          />
        </LabeledInput>
        {/* product background color */}
        <LabeledInput
          label={"Háttér szín:"}
          description={
            "Válassza ki, hogy milyen háttér színe legyen a kiválasztott termék elemnek - (alapértelmezett érték: rgba(255, 255, 255, 1) - Fehér)."
          }>
          <ColorPickerComponent
            name={"backgroundColor"}
            value={color}
            onChange={setColor}
          />
        </LabeledInput>
      </div>
      <div className="flex flex-row w-auto justify-end sticky bottom-0 bg-white p-2 border border-t">
        <Button
          onClick={submitProduct}
          className="px-4 py-2 uppercase border bg-green-500/75 text-white hover:border-green-500 hover:bg-green-500 disabled:bg-gray-500 disabled:pointer-events-none"
          btntext="Mentés"
          // disabled={!isValid}
        />
      </div>
      <Modal
        title={"Terméklista"}
        show={selectProductModal}
        onClose={() => showSelectProductModal(false)}
        height={"100%"}>
        <ProductList
          showSelectProductModal={showSelectProductModal}
          type={type}
        />
      </Modal>
    </div>
  );
};

export default EditorSingleProduct;
