import React, { useRef, useEffect } from "react";
import SelectInput from "@/components/shared/selectinput/SelectInput";
import TextInput from "@/components/shared/textinput/TextInput";
import ColorPickerComponent from "@/components/shared/colorpicker/ColorPickerComponent";
import { initialData } from "@/data/data";
import SuneditorComponent from "@/components/shared/texteditor/SuneditorComponent";
import icons from "@/assets/icons/icons";
import LabeledInput from "@/components/shared/labeledinput/LabeledInput";

const SubTextContent = ({
  editedImage,
  addRef,
  subTextContent,
  setSubTextContent,
  subTextContentColor,
  setSubTextContentColor,
}) => {
  const subtextContentRefs = useRef([]);

  useEffect(() => {
    Object.entries(subtextContentRefs.current).forEach(([key, ref]) => {
      addRef(key, ref);
    });
  });
  return (
    <div className={`w-full`}>
      {/* subtextContent */}
      <LabeledInput
        label={"Kiegészítő szöveg:"}
        description={"Adjon meg szöveges tartalmat."}>
        <SuneditorComponent
          lang={"en"}
          name={"subTextContent"}
          defaultValue={subTextContent}
          placeholder={"Ide gépelheti a szöveget..."}
          onChange={(value) => setSubTextContent(value)}
          options={{
            buttonList: [
              ["font", "fontSize", "formatBlock"],
              [
                "bold",
                "underline",
                "italic",
                "strike",
                "subscript",
                "superscript",
              ],
              ["align", "list", "table"],
              ["fontColor", "hiliteColor"],
              ["outdent", "indent"],
              ["undo", "redo"],
              ["removeFormat"],
              ["link", "image"],
              ["preview", "print"],
              ["fullScreen", "showBlocks", "codeView"],
            ],
            tableWidth: "100%",
            tableStyles: {
              border: "1px solid black",
            },
          }}
        />
      </LabeledInput>

      {/* subtext alignment */}
      <LabeledInput
        label="Kiegészítő szöveg pozíciója:"
        description="Válassza ki, hogy milyen pozícióban legyen a szöveg elem -
        (alapértelmezett érték: Balra zárt).">
        <SelectInput
          name="subtextAlignment"
          options={initialData.textAlignment}
          defaultValue={
            editedImage?.options?.subtextAlignment
              ? initialData.textAlignment.find(
                  (x) => x.value === editedImage?.options?.subtextAlignment
                )
              : initialData.textAlignment[0]
          }
          placeholder="Válasszon szöveg pozíciót"
          ref={(r) => (subtextContentRefs.current.subtextAlignment = r)}
        />
      </LabeledInput>
      {/* fontsize */}
      <LabeledInput
        label={"Betűméret:"}
        description={
          "Megadhatja, hogy a szöveges elemnek mekkora legyen a mérete, pl: 3rem, 24px, 2vh, stb."
        }>
        {" "}
        <TextInput
          type={"text"}
          name={"subTextContentSize"}
          defaultValue={editedImage?.options?.subTextContentSize ?? "2rem"}
          ref={(r) => (subtextContentRefs.current.subTextContentSize = r)}
        />
      </LabeledInput>
      {/* line height */}
      <LabeledInput
        label={"Betű vonal magasság:"}
        description={
          "Megadhatja, hogy a szöveges elemnek mekkora legyen a vonal magasság mérete, pl: 28px, stb."
        }>
        {" "}
        <TextInput
          type={"text"}
          name={"subTextLineSize"}
          defaultValue={editedImage?.options?.subTextLineSize ?? "28px"}
          ref={(r) => (subtextContentRefs.current.subTextLineSize = r)}
        />
      </LabeledInput>
      {/* subtextContent font family */}
      <LabeledInput
        label="Kiegészítő szöveg betűtípus:"
        description=" Válassza ki, hogy milyen betűtípust használjon a kiegészítő szöveg
        elem - (alapértelmezett érték: Arial).">
        <SelectInput
          name="subtextContentFontFamily"
          options={initialData.fontFamily}
          defaultValue={
            editedImage?.options?.subtextContentFontFamily
              ? initialData.fontFamily.find(
                  (x) =>
                    x.value === editedImage?.options?.subtextContentFontFamily
                )
              : initialData.fontFamily[0]
          }
          placeholder="Válasszon betűtípust"
          ref={(r) => (subtextContentRefs.current.subtextContentFontFamily = r)}
        />
      </LabeledInput>

      {/* subtextContent animation */}
      <LabeledInput
        label="Kiegészítő szöveg animáció:"
        description=" Válassza ki az animáció típusát - (alapértelmezett érték: Nincs
        animáció).">
        <SelectInput
          name="subtextAnimation"
          options={initialData.animation}
          defaultValue={
            editedImage?.options?.subtextAnimation
              ? initialData.animation.find(
                  (x) => x.value === editedImage?.options?.subtextAnimation
                )
              : initialData.animation[0]
          }
          placeholder="Válasszon animációt"
          ref={(r) => (subtextContentRefs.current.subtextAnimation = r)}
        />
      </LabeledInput>

      {/* subtextContent animation delay */}
      <LabeledInput
        label={"Szöveges tartalom animáció késleltetése:"}
        description={
          " Megadhatja, hogy a szöveges elemnek mennyi legyen az animáció késleltetése. Alapértelmezett: 1s"
        }>
        <TextInput
          type={"text"}
          name={"subtextAnimationDelay"}
          defaultValue={editedImage?.options?.subtextAnimationDelay ?? 1}
          ref={(r) => (subtextContentRefs.current.subtextAnimationDelay = r)}
        />
      </LabeledInput>

      {/* subtextContent animation duration */}
      <LabeledInput
        label={"Szöveges tartalom animáció időtartama:"}
        description={
          "Megadhatja, hogy a szöveges tartalom elemnek mennyi legyen az animáció időtartama. (pl.: 0.5, 2, 4) Alapértelmezett: 3s"
        }>
        {" "}
        <TextInput
          type={"text"}
          name={"subtextAnimationDuration"}
          defaultValue={editedImage?.options?.subtextAnimationDuration ?? 1}
          ref={(r) => (subtextContentRefs.current.subtextAnimationDuration = r)}
        />
      </LabeledInput>

      {/* subtextContent line height */}
      <LabeledInput
        label={"Kiegészítő szöveg elem sortáv:"}
        description={
          " Adjon meg kiegészítő szöveg elem sortávot. Pl.: 28px vagy 1em, 2rem, stb."
        }>
        {" "}
        <TextInput
          type={"text"}
          name={"subtextContentLineHeight"}
          defaultValue={
            editedImage?.options?.subtextContentLineHeight ?? "28px"
          }
          ref={(r) => (subtextContentRefs.current.subtextContentLineHeight = r)}
        />
      </LabeledInput>

      {/* subtextContent letter spacing */}
      <LabeledInput
        label={"Kiegészítő szöveg betűköz mérete:"}
        description={
          "Adjon meg kiegészítő szöveg elem betűköz méretet. Pl.: 28px vagy 1em, 2rem stb."
        }>
        <TextInput
          type={"text"}
          name={"subtextContentLetterSpacing"}
          defaultValue={editedImage?.options?.subtextContentLetterSpacing ?? 0}
          ref={(r) =>
            (subtextContentRefs.current.subtextContentLetterSpacing = r)
          }
        />
      </LabeledInput>

      {/* subtextcontent font size */}
      <LabeledInput
        label={"Kiegészítő szöveg mérete:"}
        description={
          "Megadhatja, hogy a kiegészítő szöveg elemnek mekkora legyen a mérete. Pl.: 28px vagy 1em, 2rem, stb. Alapértelmezett: 0"
        }>
        {" "}
        <TextInput
          type={"text"}
          name={"subtextContentFontSize"}
          defaultValue={editedImage?.options?.subtextContentFontSize ?? 0}
          ref={(r) => (subtextContentRefs.current.subtextContentFontSize = r)}
        />
      </LabeledInput>

      {/* subtextContent padding */}
      <LabeledInput
        label={"Kiegészítő szöveg eltartás:"}
        description={
          "   Megadhatja, hogy a kiegészítő szöveg elemnek mekkora eltartása legyen px-ben. Alapértelmezett: 0 0 0 0"
        }>
        <div className="w-full flex flex-row">
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2.5rem] h-[2.5rem]">
              {icons.up}
            </span>
            <input
              type="text"
              name="subtextContentPaddingTop"
              id="subtextContentPaddingTop"
              ref={(r) =>
                (subtextContentRefs.current.subtextContentPaddingTop = r)
              }
              className="w-3/4 border h-max p-2"
              defaultValue={editedImage?.options?.subtextContentPaddingTop ?? 0}
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2.5rem] h-[2.5rem]">
              {icons.right}
            </span>
            <input
              type="text"
              name="subtextContentPaddingRight"
              id="subtextContentPaddingRight"
              ref={(r) =>
                (subtextContentRefs.current.subtextContentPaddingRight = r)
              }
              className="w-3/4 border h-max p-2"
              defaultValue={
                editedImage?.options?.subtextContentPaddingRight ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2.5rem] h-[2.5rem]">
              {icons.down}
            </span>
            <input
              type="text"
              name="subtextContentPaddingBottom"
              id="subtextContentPaddingBottom"
              ref={(r) =>
                (subtextContentRefs.current.subtextContentPaddingBottom = r)
              }
              className="w-3/4 border h-max p-2"
              defaultValue={
                editedImage?.options?.subtextContentPaddingBottom ?? 0
              }
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2.5rem] h-[2.5rem]">
              {icons.left}
            </span>
            <input
              type="text"
              name="subtextContentPaddingLeft"
              id="subtextContentPaddingLeft"
              ref={(r) =>
                (subtextContentRefs.current.subtextContentPaddingLeft = r)
              }
              className="w-3/4 border h-max p-2"
              defaultValue={
                editedImage?.options?.subtextContentPaddingLeft ?? 0
              }
            />
          </div>
        </div>
      </LabeledInput>

      {/* subtextContent color */}
      <LabeledInput
        label={"Kiegészítő szöveg betű színének beállítása:"}
        description={
          "Megadhatja, hogy milyen színű legyen a kiegészítő szöveg. Alapértelmezett: #212121"
        }>
        <ColorPickerComponent
          name={"subTextContentColor"}
          value={subTextContentColor}
          onChange={setSubTextContentColor}
        />
      </LabeledInput>
    </div>
  );
};

export default SubTextContent;
