import React, { useRef, useEffect } from "react";
import SelectInput from "@/components/shared/selectinput/SelectInput";
import TextInput from "@/components/shared/textinput/TextInput";
import ColorPickerComponent from "@/components/shared/colorpicker/ColorPickerComponent";
import { initialData } from "@/data/data";
import SuneditorComponent from "@/components/shared/texteditor/SuneditorComponent";
import icons from "@/assets/icons/icons";
import LabeledInput from "@/components/shared/labeledinput/LabeledInput";

const TextContent = ({
  editedImage,
  addRef,
  textContentColor,
  setTextContentColor,
  textContent,
  setTextContent,
}) => {
  const textContentRefs = useRef([]);

  useEffect(() => {
    Object.entries(textContentRefs.current).forEach(([key, ref]) => {
      addRef(key, ref);
    });
  });

  return (
    <div className={`w-full`}>
      {/* textContent */}
      <LabeledInput
        label={"Szöveg:"}
        description={"Adjon meg szöveges tartalmat."}>
        <SuneditorComponent
          lang={"en"}
          name={"textContent"}
          defaultValue={textContent}
          placeholder={"Ide gépelheti a szöveget..."}
          onChange={(value) => setTextContent(value)}
          options={{
            buttonList: [
              ["font", "fontSize", "formatBlock"],
              [
                "bold",
                "underline",
                "italic",
                "strike",
                "subscript",
                "superscript",
              ],
              ["align", "list", "table"],
              ["fontColor", "hiliteColor"],
              ["outdent", "indent"],
              ["undo", "redo"],
              ["removeFormat"],
              ["link", "image"],
              ["preview", "print"],
              ["fullScreen", "showBlocks", "codeView"],
            ],
            tableWidth: "100%",
            tableStyles: {
              border: "1px solid black",
            },
          }}
        />
      </LabeledInput>

      {/* text size H1-H6 */}
      <LabeledInput
        label="Cím fontossága:"
        description="Válassza ki, hogy milyen fontosságú legyen a szöveg elem -
        (alapértelmezett érték: H1). A H1 elemet jellemzően csak az oldal
        tetején érdemes használni és egy oldalon csak egy H1 elem legyen.">
        <SelectInput
          name="textType"
          options={initialData.textTypes}
          defaultValue={
            editedImage?.options?.textType
              ? initialData.textTypes.find(
                  (x) => x.value === editedImage?.options?.textType
                )
              : initialData.textTypes[0]
          }
          placeholder="Válasszon cím fontosságot"
          ref={(r) => (textContentRefs.current.textType = r)}
        />
      </LabeledInput>
      {/* fontsize */}
      <LabeledInput
        label={"Betűméret:"}
        description={
          "Megadhatja, hogy a szöveges elemnek mekkora legyen a mérete, pl: 3rem, 24px, 2vh, stb."
        }>
        {" "}
        <TextInput
          type={"text"}
          name={"textContentSize"}
          defaultValue={editedImage?.options?.textContentSize ?? "3rem"}
          ref={(r) => (textContentRefs.current.textContentSize = r)}
        />
      </LabeledInput>
      {/* line height */}
      <LabeledInput
        label={"Betű vonal magasság:"}
        description={
          "Megadhatja, hogy a szöveges elemnek mekkora legyen a vonal magasság mérete, pl: 48px, stb."
        }>
        {" "}
        <TextInput
          type={"text"}
          name={"textLineSize"}
          defaultValue={editedImage?.options?.textLineSize ?? "44px"}
          ref={(r) => (textContentRefs.current.textLineSize = r)}
        />
      </LabeledInput>
      {/* text alignment */}
      <LabeledInput
        label="Szöveg pozíciója:"
        description="Válassza ki, hogy milyen pozícióban legyen a szöveg elem -
        (alapértelmezett érték: Balra zárt).">
        <SelectInput
          name="textAlignment"
          options={initialData.textAlignment}
          defaultValue={
            editedImage?.options?.textAlignment
              ? initialData.textAlignment.find(
                  (x) => x.value === editedImage?.options?.textAlignment
                )
              : initialData.textAlignment[0]
          }
          placeholder="Válasszon szöveg pozíciót"
          ref={(r) => (textContentRefs.current.textAlignment = r)}
        />
      </LabeledInput>

      {/* textContent font family */}
      <LabeledInput
        label="Betűtípus:"
        description=" Válassza ki, hogy milyen betűtípust használjon a szöveg elem -
        (alapértelmezett érték: Arial).">
        {" "}
        <SelectInput
          name="textContentFontFamily"
          options={initialData.fontFamily}
          defaultValue={
            editedImage?.options?.textContentFontFamily
              ? initialData.fontFamily.find(
                  (x) => x.value === editedImage?.options?.textContentFontFamily
                )
              : initialData.fontFamily[0]
          }
          placeholder="Válasszon betűtípust"
          ref={(r) => (textContentRefs.current.textContentFontFamily = r)}
        />
      </LabeledInput>

      {/* textContent animation */}
      <LabeledInput
        label="Animáció:"
        description=" Válassza ki az animáció típusát - (alapértelmezett érték: Nincs animáció).">
        <SelectInput
          name="textAnimation"
          options={initialData.animation}
          defaultValue={
            editedImage?.options?.textAnimation
              ? initialData.animation.find(
                  (x) => x.value === editedImage?.options?.textAnimation
                )
              : initialData.animation[0]
          }
          placeholder="Válasszon animációt"
          ref={(r) => (textContentRefs.current.textAnimation = r)}
        />
      </LabeledInput>

      {/* textcontent animation delay */}
      <LabeledInput
        label={"Szöveges tartalom animáció késleltetése:"}
        description={
          "Megadhatja, hogy a szöveges elemnek mennyi legyen az animáció késleltetése. Alapértelmezett: 1s"
        }>
        {" "}
        <TextInput
          type={"text"}
          name={"animationDelay"}
          defaultValue={editedImage?.options?.animationDelay ?? "1"}
          ref={(r) => (textContentRefs.current.animationDelay = r)}
        />
      </LabeledInput>

      {/* textcontent animation duration */}
      <LabeledInput
        label={"Szöveges tartalom animáció időtartama:"}
        description={
          "Megadhatja, hogy a szöveges tartalom elemnek mennyi legyen az animáció időtartama. (pl.: 0.5, 2, 4) Alapértelmezett: 3s"
        }>
        <TextInput
          type={"text"}
          name={"animationDuration"}
          defaultValue={editedImage?.options?.animationDuration ?? "3"}
          ref={(r) => (textContentRefs.current.animationDuration = r)}
        />
      </LabeledInput>

      {/* textContent line height */}
      <LabeledInput
        label={"Szöveg elem sortáv:"}
        description={
          "Adjon meg szöveg elem sortávot. Pl.: 28px vagy 1em, 2rem, stb."
        }>
        {" "}
        <TextInput
          type={"text"}
          name={"textContentLineHeight"}
          defaultValue={editedImage?.options?.textContentLineHeight ?? "28px"}
          ref={(r) => (textContentRefs.current.textContentLineHeight = r)}
        />
      </LabeledInput>

      {/* textContent letter spacing */}
      <LabeledInput
        label={"Szöveg betűköz mérete:"}
        description={
          "Adjon meg szöveg elem betűköz méretet. Pl.: 28px vagy 1em, 2rem stb."
        }>
        {" "}
        <TextInput
          type={"text"}
          name={"textContentLetterSpacing"}
          defaultValue={editedImage?.options?.textContentLetterSpacing ?? 0}
          ref={(r) => (textContentRefs.current.textContentLetterSpacing = r)}
        />
      </LabeledInput>

      {/* textcontent font size */}
      <LabeledInput
        label={"Szöveg mérete:"}
        description={
          "Megadhatja, hogy a szöveg elemnek mekkora legyen a mérete. Pl.: 28px vagy 1em, 2rem, stb. Alapértelmezett: 0"
        }>
        {" "}
        <TextInput
          type={"text"}
          name={"textContentFontSize"}
          defaultValue={editedImage?.options?.textContentFontSize ?? 0}
          ref={(r) => (textContentRefs.current.textContentFontSize = r)}
        />
      </LabeledInput>

      {/* textContent padding */}
      <LabeledInput
        label={"Szöveg eltartás:"}
        description={
          " Megadhatja, hogy a szöveg elemnek mekkora eltartása legyen px-ben. Alapértelmezett: 0 0 0 0"
        }>
        <div className="w-full flex flex-row">
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2.5rem] h-[2.5rem]">
              {icons.up}
            </span>
            <input
              type="text"
              name="textContentPaddingTop"
              id="textContentPaddingTop"
              ref={(r) => (textContentRefs.current.textContentPaddingTop = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={editedImage?.options?.textContentPaddingTop ?? 0}
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2.5rem] h-[2.5rem]">
              {icons.right}
            </span>
            <input
              type="text"
              name="textContentPaddingRight"
              id="textContentPaddingRight"
              ref={(r) => (textContentRefs.current.textContentPaddingRight = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={editedImage?.options?.textContentPaddingRight ?? 0}
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2.5rem] h-[2.5rem]">
              {icons.down}
            </span>
            <input
              type="text"
              name="textContentPaddingBottom"
              id="textContentPaddingBottom"
              ref={(r) =>
                (textContentRefs.current.textContentPaddingBottom = r)
              }
              className="w-3/4 border h-max p-2"
              defaultValue={editedImage?.options?.textContentPaddingBottom ?? 0}
            />
          </div>
          <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
            <span className="fill-gray-600 w-[2.5rem] h-[2.5rem]">
              {icons.left}
            </span>
            <input
              type="text"
              name="textContentPaddingLeft"
              id="textContentPaddingLeft"
              ref={(r) => (textContentRefs.current.textContentPaddingLeft = r)}
              className="w-3/4 border h-max p-2"
              defaultValue={editedImage?.options?.textContentPaddingLeft ?? 0}
            />
          </div>
        </div>
      </LabeledInput>

      {/* textcontent color */}
      <LabeledInput
        label={"Fő szöveg betű színének beállítása:"}
        description={
          " Megadhatja, hogy milyen színű legyen a fő szöveg. Alapértelmezett: #212121."
        }>
        {" "}
        <ColorPickerComponent
          name={"textContentColor"}
          value={textContentColor}
          onChange={setTextContentColor}
        />
      </LabeledInput>
    </div>
  );
};

export default TextContent;
