import React, { useState, useRef, useCallback } from "react";
import dynamic from "next/dynamic";
import Select from "react-select";
import { initialData } from "@/data/data";
import icons from "@/assets/icons/icons";
import ModalButton from "@/components/shared/modal/ModalButton";
import useDynamicManager from "@/store/managers/useDynamicManager";

const ColorPicker = dynamic(() => import("react-best-gradient-color-picker"), {
  ssr: false,
});
const SunEditor = dynamic(() => import("suneditor-react"), { ssr: false });

const Title = ({ toggleModal, modalName, type }) => {
  const { state, selectedElement, addcurrentElementToColumn } =
    useDynamicManager(type);
  const content = state?.current?.content?.[0]?.content?.[0] ?? {};
  const inputRefs = useRef([]);
  const [titleText, setTitleText] = useState(content?.titleTextContent ?? "");
  const [color, setColor] = useState(content?.fontColor ?? "#212121");
  const [backgroundColor, setBackgroundColor] = useState(
    content?.backgroundColor ?? "rgb(255, 255, 255, 0)"
  );

  // New padding state variables
  const [titlePaddingTop, setTitlePaddingTop] = useState(
    content?.titlePaddingTop ?? 0
  );
  const [titlePaddingRight, setTitlePaddingRight] = useState(
    content?.titlePaddingRight ?? 0
  );
  const [titlePaddingBottom, setTitlePaddingBottom] = useState(
    content?.titlePaddingBottom ?? 0
  );
  const [titlePaddingLeft, setTitlePaddingLeft] = useState(
    content?.titlePaddingLeft ?? 0
  );

  let index = 0;

  const buildContentObject = () => {
    const updatedContent = {
      type: "title",
      title: "Cím",
      titleTextContent: titleText,
      fontColor: color,
      backgroundColor: backgroundColor,
      titlePaddingTop,
      titlePaddingRight,
      titlePaddingBottom,
      titlePaddingLeft,
    };

    inputRefs.current.forEach((ref) => {
      if (ref) {
        if (ref?.props) {
          updatedContent[ref.props.name] = Array.isArray(ref?.props?.value)
            ? ref?.props?.value?.[0]?.value
            : ref?.props?.value?.value;
        } else {
          updatedContent[ref.name] = ref?.value;
        }
      }
    });

    return updatedContent;
  };

  const submitTitle = useCallback(() => {
    selectedElement({ content: buildContentObject() });
    addcurrentElementToColumn();
    toggleModal(modalName);
    toggleModal("showSelectElementModal");
  }, [
    titleText,
    color,
    backgroundColor,
    titlePaddingTop,
    titlePaddingRight,
    titlePaddingBottom,
    titlePaddingLeft,
  ]);

  const renderInput = (name, label, defaultValue, placeholder = "") => (
    <div className="flex flex-row w-full mb-4 pb-4 border-b">
      <label htmlFor={name} className="w-1/4 text-sm text-gray-600 pr-2">
        <p className="font-bold">{label}</p>
      </label>
      <input
        type="text"
        name={name}
        id={name}
        ref={(r) => (inputRefs.current[index++] = r)}
        className="w-3/4 border p-2"
        defaultValue={defaultValue}
        placeholder={placeholder}
      />
    </div>
  );

  const renderSelect = (options, name, label, defaultVal) => (
    <div className="flex flex-row w-full mb-4 pb-4 border-b">
      <label htmlFor={name} className="w-1/4 text-sm text-gray-600 pr-2">
        <p className="font-bold">{label}</p>
      </label>
      <Select
        options={options}
        className="w-3/4"
        placeholder={`Válasszon ${label.toLowerCase()}`}
        menuPosition="fixed"
        name={name}
        ref={(r) => (inputRefs.current[index++] = r)}
        defaultValue={defaultVal}
        required
      />
    </div>
  );

  return (
    <div className="relative">
      <div className="flex flex-col w-full p-4">
        {renderSelect(
          initialData.editor.title.titleTypes,
          "titleType",
          "Cím fontossága",
          initialData.editor.title.titleTypes.find(
            (x) => x.value === content.titleType
          ) || initialData.editor.title.titleTypes[0]
        )}

        {renderInput(
          "titleFontSize",
          "Szöveg mérete",
          content?.titleFontSize ?? "1rem"
        )}

        {renderSelect(
          initialData.fontWeight,
          "fontWeight",
          "Cím betű súly",
          initialData.fontWeight.find((x) => x.value === content.fontWeight) ||
            initialData.fontWeight[12]
        )}

        {renderSelect(
          initialData.animation,
          "animationTypes",
          "Cím animációja",
          initialData.animation.find(
            (x) => x.value === content?.animationTypes
          ) || initialData.animation[0]
        )}

        {renderInput(
          "animationDelay",
          "Cím animáció késleltetése",
          content?.animationDelay ?? 1
        )}

        {renderInput(
          "animationDuration",
          "Cím animáció időtartama",
          content?.animationDuration ?? 3
        )}

        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label
            htmlFor="titleText"
            className="w-1/4 text-sm text-gray-600 pr-2">
            <p className="font-bold">Cím szövege</p>
          </label>
          <SunEditor
            lang="en"
            name="titleText"
            defaultValue={titleText}
            onChange={setTitleText}
            width="100%"
            height="100%"
            setOptions={{
              buttonList: [
                ["bold", "underline", "italic"],
                ["align", "list"],
                ["undo", "redo"],
                ["fontColor", "hiliteColor"],
                ["removeFormat", "preview"],
              ],
              callBackSave: (contents) => setTitleText(contents),
            }}
          />
        </div>

        {renderInput(
          "titleLineHeight",
          "Cím elem sortáv",
          content?.titleLineHeight ?? "28px"
        )}

        {renderSelect(
          initialData.editor.title.titleOrder,
          "titleOrder",
          "Cím tartalom elrendezés",
          initialData.editor.title.titleOrder.find(
            (x) => x.value === content.titleOrder
          ) || initialData.editor.title.titleOrder[1]
        )}

        {renderSelect(
          initialData.editor.title.titleAlignment,
          "titleAlignment",
          "Cím pozíciója",
          initialData.editor.title.titleAlignment.find(
            (x) => x.value === content.titleAlignment
          ) || initialData.editor.title.titleAlignment[0]
        )}

        {renderInput(
          "titleHeight",
          "Cím magasság",
          content?.titleHeight ?? "inherit"
        )}

        {renderInput(
          "maxHeight",
          "Cím maximum magasság",
          content?.maxHeight ?? "inherit"
        )}

        {/* Padding Inputs */}
        {renderInput("titlePaddingTop", "Padding Top", titlePaddingTop ?? "0")}

        {renderInput(
          "titlePaddingRight",
          "Padding Right",
          titlePaddingRight ?? "0"
        )}

        {renderInput(
          "titlePaddingBottom",
          "Padding Bottom",
          titlePaddingBottom ?? "0"
        )}

        {renderInput(
          "titlePaddingLeft",
          "Padding Left",
          titlePaddingLeft ?? "0"
        )}

        {/* Color pickers */}
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label className="w-1/4 text-sm text-gray-600 pr-2 font-bold">
            Háttér szín
          </label>
          <ColorPicker value={backgroundColor} onChange={setBackgroundColor} />
        </div>
        <div className="flex flex-row w-full mb-4 pb-4 border-b">
          <label className="w-1/4 text-sm text-gray-600 pr-2 font-bold">
            Betű szín
          </label>
          <ColorPicker value={color} onChange={setColor} />
        </div>
      </div>

      <ModalButton
        disabled={!titleText}
        btntext="Mentés"
        callback={submitTitle}
      />
    </div>
  );
};

export default Title;

// // REFACTORED Title.jsx
// import React, { useState, useRef, useCallback } from "react";
// import dynamic from "next/dynamic";
// import Select from "react-select";
// import { initialData } from "@/data/data";
// import icons from "@/assets/icons/icons";
// import ModalButton from "@/components/shared/modal/ModalButton";
// import useDynamicManager from "@/store/managers/useDynamicManager";

// const ColorPicker = dynamic(() => import("react-best-gradient-color-picker"), {
//   ssr: false,
// });
// const SunEditor = dynamic(() => import("suneditor-react"), { ssr: false });

// const Title = ({ toggleModal, modalName, type }) => {
//   const { state, selectedElement, addcurrentElementToColumn } =
//     useDynamicManager(type);
//   const content = state?.current?.content?.[0]?.content?.[0] ?? {};
//   const inputRefs = useRef([]);
//   const [titleText, setTitleText] = useState(content?.titleTextContent ?? "");
//   const [color, setColor] = useState(content?.fontColor ?? "#212121");
//   const [backgroundColor, setBackgroundColor] = useState(
//     content?.backgroundColor ?? "rgb(255, 255, 255, 0)"
//   );
//   let index = 0;

//   const buildContentObject = () => {
//     const updatedContent = {
//       type: "title",
//       title: "Cím",
//       titleTextContent: titleText,
//       fontColor: color,
//       backgroundColor: backgroundColor,
//     };

//     inputRefs.current.forEach((ref) => {
//       if (ref) {
//         if (ref?.props) {
//           updatedContent[ref.props.name] = Array.isArray(ref?.props?.value)
//             ? ref?.props?.value?.[0]?.value
//             : ref?.props?.value?.value;
//         } else {
//           updatedContent[ref.name] = ref?.value;
//         }
//       }
//     });

//     return updatedContent;
//   };

//   const submitTitle = useCallback(() => {
//     selectedElement({ content: buildContentObject() });
//     addcurrentElementToColumn();
//     toggleModal(modalName);
//     toggleModal("showSelectElementModal");
//   }, [titleText, color, backgroundColor]);

//   const renderInput = (name, label, defaultValue, placeholder = "") => (
//     <div className="flex flex-row w-full mb-4 pb-4 border-b">
//       <label htmlFor={name} className="w-1/4 text-sm text-gray-600 pr-2">
//         <p className="font-bold">{label}</p>
//       </label>
//       <input
//         type="text"
//         name={name}
//         id={name}
//         ref={(r) => (inputRefs.current[index++] = r)}
//         className="w-3/4 border p-2"
//         defaultValue={defaultValue}
//         placeholder={placeholder}
//       />
//     </div>
//   );

//   const renderSelect = (options, name, label, defaultVal) => (
//     <div className="flex flex-row w-full mb-4 pb-4 border-b">
//       <label htmlFor={name} className="w-1/4 text-sm text-gray-600 pr-2">
//         <p className="font-bold">{label}</p>
//       </label>
//       <Select
//         options={options}
//         className="w-3/4"
//         placeholder={`Válasszon ${label.toLowerCase()}`}
//         menuPosition="fixed"
//         name={name}
//         ref={(r) => (inputRefs.current[index++] = r)}
//         defaultValue={defaultVal}
//         required
//       />
//     </div>
//   );

//   return (
//     <div className="relative">
//       <div className="flex flex-col w-full p-4">
//         {renderSelect(
//           initialData.editor.title.titleTypes,
//           "titleType",
//           "Cím fontossága",
//           initialData.editor.title.titleTypes.find(
//             (x) => x.value === content.titleType
//           ) || initialData.editor.title.titleTypes[0]
//         )}

//         {renderInput(
//           "titleFontSize",
//           "Szöveg mérete",
//           content?.titleFontSize ?? "1rem"
//         )}

//         {renderSelect(
//           initialData.fontWeight,
//           "fontWeight",
//           "Cím betű súly",
//           initialData.fontWeight.find((x) => x.value === content.fontWeight) ||
//             initialData.fontWeight[12]
//         )}

//         {renderSelect(
//           initialData.animation,
//           "animationTypes",
//           "Cím animációja",
//           initialData.animation.find(
//             (x) => x.value === content?.animationTypes
//           ) || initialData.animation[0]
//         )}

//         {renderInput(
//           "animationDelay",
//           "Cím animáció késleltetése",
//           content?.animationDelay ?? 1
//         )}

//         {renderInput(
//           "animationDuration",
//           "Cím animáció időtartama",
//           content?.animationDuration ?? 3
//         )}

//         <div className="flex flex-row w-full mb-4 pb-4 border-b">
//           <label
//             htmlFor="titleText"
//             className="w-1/4 text-sm text-gray-600 pr-2">
//             <p className="font-bold">Cím szövege</p>
//           </label>
//           <SunEditor
//             lang="en"
//             name="titleText"
//             defaultValue={titleText}
//             onChange={setTitleText}
//             width="100%"
//             height="100%"
//             setOptions={{
//               buttonList: [
//                 ["bold", "underline", "italic"],
//                 ["align", "list"],
//                 ["undo", "redo"],
//                 ["fontColor", "hiliteColor"],
//                 ["removeFormat", "preview"],
//               ],
//               callBackSave: (contents) => setTitleText(contents),
//             }}
//           />
//         </div>

//         {renderInput(
//           "titleLineHeight",
//           "Cím elem sortáv",
//           content?.titleLineHeight ?? "28px"
//         )}

//         {renderSelect(
//           initialData.editor.title.titleOrder,
//           "titleOrder",
//           "Cím tartalom elrendezés",
//           initialData.editor.title.titleOrder.find(
//             (x) => x.value === content.titleOrder
//           ) || initialData.editor.title.titleOrder[1]
//         )}

//         {renderSelect(
//           initialData.editor.title.titleAlignment,
//           "titleAlignment",
//           "Cím pozíciója",
//           initialData.editor.title.titleAlignment.find(
//             (x) => x.value === content.titleAlignment
//           ) || initialData.editor.title.titleAlignment[0]
//         )}

//         {renderInput(
//           "titleHeight",
//           "Cím magasság",
//           content?.titleHeight ?? "inherit"
//         )}

//         {renderInput(
//           "maxHeight",
//           "Cím maximum magasság",
//           content?.maxHeight ?? "inherit"
//         )}

//         {/* Color pickers */}
//         <div className="flex flex-row w-full mb-4 pb-4 border-b">
//           <label className="w-1/4 text-sm text-gray-600 pr-2 font-bold">
//             Háttér szín
//           </label>
//           <ColorPicker value={backgroundColor} onChange={setBackgroundColor} />
//         </div>
//         <div className="flex flex-row w-full mb-4 pb-4 border-b">
//           <label className="w-1/4 text-sm text-gray-600 pr-2 font-bold">
//             Betű szín
//           </label>
//           <ColorPicker value={color} onChange={setColor} />
//         </div>
//       </div>

//       <ModalButton
//         disabled={!titleText}
//         btntext="Mentés"
//         callback={submitTitle}
//       />
//     </div>
//   );
// };

// export default Title;

// // import React, { useState, useCallback, useRef } from "react";
// // import { initialData } from "@/data/data";
// // import Select from "react-select";
// // import dynamic from "next/dynamic";
// // import "react-quill/dist/quill.snow.css";
// // import icons from "@/assets/icons/icons";
// // import ModalButton from "@/components/shared/modal/ModalButton";
// // import useDynamicManager from "@/store/managers/useDynamicManager";

// // const ColorPicker = dynamic(() => import("react-best-gradient-color-picker"), {
// //   ssr: false,
// // });

// // const SunEditor = dynamic(() => import("suneditor-react"), {
// //   ssr: false,
// // });

// // const Title = ({ toggleModal, modalName, type }) => {
// //   const { state, selectedElement, addcurrentElementToColumn } =
// //     useDynamicManager(type);
// //   const content = state?.current?.content?.[0]?.content?.[0] ?? {};

// //   const inputRefs = useRef([]);
// //   let index = 0;

// //   const [color, setColor] = useState(content?.fontColor ?? "#212121");
// //   const [backgroundColor, setBackgroundColor] = useState(
// //     content?.backgroundColor ?? "#fff"
// //   );

// //   const [titleText, setTitleText] = useState(content?.titleTextContent ?? "");

// //   const submitTitle = useCallback(() => {
// //     const content = {
// //       type: "title",
// //       title: "Cím",
// //       titleTextContent: titleText,
// //       fontColor: color,
// //       backgroundColor: backgroundColor,
// //     };
// //     inputRefs.current.map((c, i) => {
// //       if (c) {
// //         if (c?.props) {
// //           if (Array.isArray(c?.props?.value)) {
// //             content[c.props.name] = c?.props?.value?.[0]?.value;
// //           } else {
// //             content[c.props.name] = c?.props?.value?.value;
// //           }
// //         } else {
// //           content[c.name] = c?.value;
// //         }
// //       }
// //     });

// //     selectedElement({ content: content });

// //     addcurrentElementToColumn();
// //     toggleModal(modalName);
// //     toggleModal("showSelectElementModal");
// //   }, [titleText, color, backgroundColor, inputRefs]);

// //   const handleEditorContentChange = (value) => {
// //     setTitleText(value);
// //   };

// //   return (
// //     <div className="relative">
// //       <div className="blog-wrapper flex flex-col w-full p-4">
// //         {/* title size H1-H6 */}
// //         <div className="flex flex-row w-full mb-4 pb-4 border-b">
// //           <label
// //             htmlFor={"titleType"}
// //             className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
// //             <p className="w-full font-bold">Cím fontossága: </p>
// //             <span className="w-full text-sm text-gray-600 whitespace-pre-line">
// //               Válassza ki, hogy milyen fontosságú legyen a cím elem -
// //               (alapértelmezett érték: H1). A H1 elemet jellemzően csak az oldal
// //               tetején érdemes használni és egy oldalon csak egy H1 elem legyen.
// //             </span>
// //           </label>

// //           <Select
// //             options={initialData.editor.title.titleTypes}
// //             className="w-3/4 z-50"
// //             placeholder={"Válasszon cím fontosságot"}
// //             menuPosition={"fixed"}
// //             backspaceRemovesValue={false}
// //             name={"titleType"}
// //             ref={(r) => (inputRefs.current[index++] = r)}
// //             defaultValue={
// //               content?.titleType
// //                 ? initialData.editor.title.titleTypes.find(
// //                     (x) => x.value === content.titleType
// //                   )
// //                 : initialData.editor.title.titleTypes[0]
// //             }
// //             onChange={(val, e) => {
// //               // second parameter shows action triggered
// //               // dispatch(selectParentPage({ parent: val }));
// //             }}
// //             required
// //           />
// //         </div>
// //         {/* title font size */}
// //         <div className="flex flex-row w-full mb-4 pb-4 border-b">
// //           <label
// //             htmlFor={"titleFontSize"}
// //             className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
// //             <p className="w-full font-bold">Szöveg mérete: </p>
// //             <span className="w-full text-sm text-gray-600 whitespace-pre-line">
// //               Megadhatja, hogy a szöveg elemnek mekkora legyen a mérete. Pl.:
// //               28px vagy 1em, 2rem, stb. Alapértelmezett: 1rem
// //             </span>
// //           </label>

// //           <input
// //             type="text"
// //             name="titleFontSize"
// //             id="titleFontSize"
// //             ref={(r) => (inputRefs.current[index++] = r)}
// //             className="w-3/4 border h-max p-2"
// //             defaultValue={content?.titleFontSize ?? "1rem"}
// //           />
// //         </div>
// //         {/* title weight */}
// //         <div className="flex flex-row w-full mb-4 pb-4 border-b">
// //           <label
// //             htmlFor={"fontWeight"}
// //             className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
// //             <p className="w-full font-bold">Cím betű súly: </p>
// //             <span className="w-full text-sm text-gray-600 whitespace-pre-line">
// //               Válassza ki, hogy milyen súlyú legyen a cím elem -
// //               (alapértelmezett érték: normal).
// //             </span>
// //           </label>

// //           <Select
// //             options={initialData.fontWeight}
// //             className="w-3/4 z-50"
// //             placeholder={"Válasszon cím betű súlyt"}
// //             menuPosition={"fixed"}
// //             backspaceRemovesValue={false}
// //             name={"fontWeight"}
// //             ref={(r) => (inputRefs.current[index++] = r)}
// //             defaultValue={
// //               content?.fontWeight
// //                 ? initialData.fontWeight.find(
// //                     (x) => x.value === content.fontWeight
// //                   )
// //                 : initialData.fontWeight[12]
// //             }
// //             onChange={(val, e) => {
// //               // second parameter shows action triggered
// //               // dispatch(selectParentPage({ parent: val }));
// //             }}
// //             required
// //           />
// //         </div>
// //         {/* title animation type */}
// //         <div className="flex flex-row w-full mb-4 p-4 border-b">
// //           <label
// //             htmlFor={"animationTypes"}
// //             className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
// //             <p className="w-full font-bold">Cím animációja: </p>
// //             <span className="w-full text-sm text-gray-600 whitespace-pre-line">
// //               Válassza ki a cím elem animációját. (alapértelmezett: Nincs
// //               animáció)
// //             </span>
// //           </label>

// //           <Select
// //             options={initialData.animation}
// //             className="w-3/4"
// //             menuPosition={"fixed"}
// //             placeholder={"Válasszon animáció típust"}
// //             backspaceRemovesValue={false}
// //             name={"animationTypes"}
// //             ref={(r) => (inputRefs.current[index++] = r)}
// //             defaultValue={
// //               content?.animationTypes
// //                 ? initialData.animation.find(
// //                     (x) => x.value === content?.animationTypes
// //                   )
// //                 : initialData.animation[0]
// //             }
// //             onChange={(val, e) => {
// //               // second parameter shows action triggered
// //               // dispatch(selectParentPage({ parent: val }));
// //             }}
// //             required
// //           />
// //         </div>
// //         {/* title animation delay */}
// //         <div className="flex flex-row w-full mb-4 pb-4 border-b">
// //           <label
// //             htmlFor={"animationDelay"}
// //             className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
// //             <p className="w-full font-bold">Cím animáció késleltetése: </p>
// //             <span className="w-full text-sm text-gray-600 whitespace-pre-line">
// //               Megadhatja, hogy a cím elemnek mennyi legyen az animáció
// //               késleltetése. Alapértelmezett: 1s
// //             </span>
// //           </label>
// //           <div className="flex flex-row flex-nowrap justify-evenly items-center">
// //             <input
// //               type="text"
// //               name="animationDelay"
// //               id="animationDelay"
// //               ref={(r) => (inputRefs.current[index++] = r)}
// //               className="w-3/4 border h-max p-2"
// //               defaultValue={content?.animationDelay ?? 1}
// //             />
// //           </div>
// //         </div>
// //         {/* title animation duration */}
// //         <div className="flex flex-row w-full mb-4 pb-4 border-b">
// //           <label
// //             htmlFor={"animationDuration"}
// //             className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
// //             <p className="w-full font-bold">Cím animáció időtartama: </p>
// //             <span className="w-full text-sm text-gray-600 whitespace-pre-line">
// //               Megadhatja, hogy a cím elemnek mennyi legyen az animáció
// //               időtartama. (pl.: 0.5, 2, 4) Alapértelmezett: 3s
// //             </span>
// //           </label>
// //           <div className="flex flex-row flex-nowrap justify-evenly items-center">
// //             <input
// //               type="text"
// //               name="animationDuration"
// //               id="animationDuration"
// //               ref={(r) => (inputRefs.current[index++] = r)}
// //               className="w-3/4 border h-max p-2"
// //               defaultValue={content?.animationDuration ?? 3}
// //             />
// //           </div>
// //         </div>
// //         {/* title text */}
// //         <div className="flex flex-row w-full mb-4 pb-4 border-b h-max-content">
// //           <label
// //             htmlFor={"titleText"}
// //             className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
// //             <p className="w-full font-bold">Cím szövege: </p>
// //             <span className="w-full text-sm text-gray-600 whitespace-pre-line">
// //               Adjon meg cím szöveget.
// //             </span>
// //           </label>
// //           <SunEditor
// //             lang="en"
// //             name="titleText"
// //             defaultValue={titleText}
// //             width="100%"
// //             height="100%"
// //             placeholder="Cím szövege"
// //             autoFocus={false}
// //             onChange={handleEditorContentChange}
// //             setOptions={{
// //               buttonList: [
// //                 ["font", "fontSize", "formatBlock"],
// //                 [
// //                   "bold",
// //                   "underline",
// //                   "italic",
// //                   "strike",
// //                   "subscript",
// //                   "superscript",
// //                 ],
// //                 ["align", "list", "table"],
// //                 ["fontColor", "hiliteColor"],
// //                 ["outdent", "indent"],
// //                 ["undo", "redo"],
// //                 ["removeFormat"],
// //                 ["link"],
// //                 ["fullScreen", "showBlocks", "codeView", "save", "preview"],
// //               ],
// //               tableWidth: "100%",
// //               tableStyles: {
// //                 border: "1px solid black",
// //               },
// //               callBackSave: (contents) => handleEditorContentChange(contents),
// //             }}
// //           />
// //         </div>
// //         {/* title line height */}
// //         <div className="flex flex-row w-full mb-4 pb-4 border-b">
// //           <label
// //             htmlFor={"titleLineHeight"}
// //             className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
// //             <p className="w-full font-bold">Cím elem sortáv: </p>
// //             <span className="w-full text-sm text-gray-600 whitespace-pre-line">
// //               Adjon meg cím elem sortávot. Pl.: 28px vagy 1em, 2rem, stb.
// //             </span>
// //           </label>
// //           <input
// //             type="text"
// //             name="titleLineHeight"
// //             id="titleLineHeight"
// //             ref={(r) => (inputRefs.current[index++] = r)}
// //             className="w-3/4 border h-max p-2"
// //             defaultValue={content?.titleLineHeight ?? "28px"}
// //           />
// //         </div>
// //         {/* title content order */}
// //         <div className="flex flex-row w-full mb-4 pb-4 border-b">
// //           <label
// //             htmlFor={"titleOrder"}
// //             className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
// //             <p className="w-full font-bold">Cím tartalom elrendezés: </p>
// //             <span className="w-full text-sm text-gray-600 whitespace-pre-line">
// //               Válassza ki, hogy sor vagy oszlop legyen a tartalmi elrendezés.
// //               (alapértelmezett: Oszlop)
// //             </span>
// //           </label>
// //           <Select
// //             options={initialData?.editor?.title?.titleOrder}
// //             className="w-3/4"
// //             menuPosition={"fixed"}
// //             placeholder={
// //               "Válassza ki, hogy sor vagy oszlop legyen a tartalmi elrendezés."
// //             }
// //             backspaceRemovesValue={false}
// //             name={"titleOrder"}
// //             ref={(r) => (inputRefs.current[index++] = r)}
// //             defaultValue={
// //               content?.titleOrder
// //                 ? initialData?.editor?.title?.titleOrder?.find(
// //                     (x) => x.value === content?.titleOrder
// //                   )
// //                 : initialData?.editor?.title?.titleOrder[1]
// //             }
// //             onChange={(val, e) => {
// //               // second parameter shows action triggered
// //               // dispatch(selectParentPage({ parent: val }));
// //             }}
// //             required
// //           />
// //         </div>
// //         {/* title alignment */}
// //         <div className="flex flex-row w-full mb-4 pb-4 border-b">
// //           <label
// //             htmlFor={"titleAlignment"}
// //             className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
// //             <p className="w-full font-bold">Cím pozíciója: </p>
// //             <span className="w-full text-sm text-gray-600 whitespace-pre-line">
// //               Válassza ki, hogy milyen pozícióban legyen a cím elem -
// //               (alapértelmezett érték: Balra zárt).
// //             </span>
// //           </label>

// //           <Select
// //             options={initialData.editor.title.titleAlignment}
// //             className="w-3/4"
// //             placeholder={"Válasszon cím pozíciót"}
// //             menuPosition={"fixed"}
// //             backspaceRemovesValue={false}
// //             name={"titleAlignment"}
// //             ref={(r) => (inputRefs.current[index++] = r)}
// //             defaultValue={
// //               content?.titleAlignment
// //                 ? initialData.editor.title.titleAlignment.find(
// //                     (x) => x.value === content.titleAlignment
// //                   )
// //                 : initialData.editor.title.titleAlignment[0]
// //             }
// //             onChange={(val, e) => {
// //               // second parameter shows action triggered
// //               // dispatch(selectParentPage({ parent: val }));
// //             }}
// //             required
// //           />
// //         </div>
// //         {/* title height*/}
// //         <div className="flex flex-row w-full mb-4 pb-4 border-b">
// //           <label
// //             htmlFor={"titleHeight"}
// //             className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
// //             <p className="w-full font-bold">Cím magasság: </p>
// //             <span className="w-full text-sm text-gray-600 whitespace-pre-line">
// //               Megadhatja, hogy a cím elemnek mekkora magassága legyen.
// //               Alapértelmezett: inherit. Lehetséges értékek: auto, fit-content,
// //               inherit, initial, max-content, min-content, revert, unset, px, vh,
// //               rem, em
// //             </span>
// //           </label>

// //           <div className="flex flex-row flex-nowrap justify-evenly items-center">
// //             <div className="flex flex-row flex-nowrap w-3/4 justify-evenly items-center max-h-10">
// //               <span className="fill-gray-600 w-[2.5rem] h-[2.5rem]">
// //                 {icons.up}
// //                 {icons.down}
// //               </span>
// //               <input
// //                 type="text"
// //                 name="titleHeight"
// //                 id="titleHeight"
// //                 ref={(r) => (inputRefs.current[index++] = r)}
// //                 className="w-3/4 border h-max p-2"
// //                 defaultValue={content?.titleHeight ?? "inherit"}
// //               />
// //             </div>
// //           </div>
// //         </div>
// //         {/* title max height*/}
// //         <div className="flex flex-row w-full mb-4 pb-4 border-b">
// //           <label
// //             htmlFor={"maxHeight"}
// //             className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
// //             <p className="w-full font-bold">Cím maximum magasság: </p>
// //             <span className="w-full text-sm text-gray-600 whitespace-pre-line">
// //               Megadhatja, hogy a cím elemnek mekkora maximum magassága legyen.
// //               Alapértelmezett: inherit. Lehetséges értékek: auto, fit-content,
// //               inherit, initial, max-content, min-content, revert, unset, px, vh,
// //               rem, em
// //             </span>
// //           </label>

// //           <div className="flex flex-row flex-nowrap justify-evenly items-center">
// //             <div className="flex flex-row flex-nowrap w-3/4 justify-evenly items-center max-h-10">
// //               <span className="fill-gray-600 w-[2.5rem] h-[2.5rem]">
// //                 {icons.up}
// //                 {icons.down}
// //               </span>
// //               <input
// //                 type="text"
// //                 name="maxHeight"
// //                 id="maxHeight"
// //                 ref={(r) => (inputRefs.current[index++] = r)}
// //                 className="w-3/4 border h-max p-2"
// //                 defaultValue={content?.maxHeight ?? "inherit"}
// //               />
// //             </div>
// //           </div>
// //         </div>
// //         {/* title padding */}
// //         <div className="flex flex-row w-full mb-4 pb-4 border-b">
// //           <label
// //             htmlFor={"titlePadding"}
// //             className="w-1/4 text-normal text-gray-400 whitespace-pre-line flex-flex-col flex-wrap pr-2">
// //             <p className="w-full font-bold">Cím eltartás: </p>
// //             <span className="w-full text-sm text-gray-600 whitespace-pre-line">
// //               Megadhatja, hogy a cím elemnek mekkora eltartása legyen px-ben.
// //               Alapértelmezett: 0 0 0 0
// //             </span>
// //           </label>
// //           {content?.length > 0 && (
// //             <>
// //               <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
// //                 <span className="fill-gray-600 w-[2.5rem] h-[2.5rem]">
// //                   {icons.up}
// //                 </span>
// //                 <input
// //                   type="text"
// //                   name="titlePaddingTop"
// //                   id="titlePaddingTop"
// //                   ref={(r) => (inputRefs.current[index++] = r)}
// //                   className="w-3/4 border h-max p-2"
// //                   defaultValue={content?.titlePaddingTop ?? 0}
// //                 />
// //               </div>
// //               <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
// //                 <span className="fill-gray-600 w-[2.5rem] h-[2.5rem]">
// //                   {icons.right}
// //                 </span>
// //                 <input
// //                   type="text"
// //                   name="titlePaddingRight"
// //                   id="titlePaddingRight"
// //                   ref={(r) => (inputRefs.current[index++] = r)}
// //                   className="w-3/4 border h-max p-2"
// //                   defaultValue={content?.titlePaddingRight ?? 0}
// //                 />
// //               </div>
// //               <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
// //                 <span className="fill-gray-600 w-[2.5rem] h-[2.5rem]">
// //                   {icons.down}
// //                 </span>
// //                 <input
// //                   type="text"
// //                   name="titlePaddingBottom"
// //                   id="titlePaddingBottom"
// //                   ref={(r) => (inputRefs.current[index++] = r)}
// //                   className="w-3/4 border h-max p-2"
// //                   defaultValue={content?.titlePaddingBottom ?? 0}
// //                 />
// //               </div>
// //               <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
// //                 <span className="fill-gray-600 w-[2.5rem] h-[2.5rem]">
// //                   {icons.left}
// //                 </span>
// //                 <input
// //                   type="text"
// //                   name="titlePaddingLeft"
// //                   id="titlePaddingLeft"
// //                   ref={(r) => (inputRefs.current[index++] = r)}
// //                   className="w-3/4 border h-max p-2"
// //                   defaultValue={content?.titlePaddingLeft ?? 0}
// //                 />
// //               </div>
// //             </>
// //           )}
// //         </div>
// //         {/* font family */}
// //         <div className="flex flex-row w-full mb-4 pb-4 border-b">
// //           <label
// //             htmlFor={"fontFamily"}
// //             className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
// //             <p className="w-full font-bold">Betűtípus: </p>
// //             <span className="w-full text-sm text-gray-600 whitespace-pre-line">
// //               Válassza ki, hogy milyen betűtípust használjon a cím elem -
// //               (alapértelmezett érték: Arial).
// //             </span>
// //           </label>

// //           <Select
// //             options={initialData.editor.title.fontFamily}
// //             className="w-3/4"
// //             placeholder={"Válasszon betűtípust"}
// //             menuPosition={"fixed"}
// //             backspaceRemovesValue={false}
// //             name={"fontFamily"}
// //             ref={(r) => (inputRefs.current[index++] = r)}
// //             defaultValue={
// //               content?.fontFamily
// //                 ? initialData.editor.title.fontFamily.find(
// //                     (x) => x.value === content.fontFamily
// //                   )
// //                 : initialData.editor.title.fontFamily[0]
// //             }
// //             onChange={(val, e) => {
// //               // second parameter shows action triggered
// //               // dispatch(selectParentPage({ parent: val }));
// //             }}
// //             required
// //           />
// //         </div>
// //         {/* background color */}
// //         <div className="flex flex-row w-full mb-4 pb-4 border-b">
// //           <label
// //             htmlFor={"fontColor"}
// //             className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
// //             <p className="w-full font-bold">Háttér szín: </p>
// //             <span className="w-full text-sm text-gray-600 whitespace-pre-line">
// //               Válassza ki, hogy milyen színű legyen a cím elem háttere -
// //               (alapértelmezett érték: #fff - Fehér).
// //             </span>
// //           </label>

// //           <div className="w-3/4 flex flex-row justify-center align-center">
// //             <ColorPicker
// //               value={backgroundColor}
// //               onChange={setBackgroundColor}
// //             />
// //           </div>
// //         </div>
// //         {/* font color */}
// //         <div className="flex flex-row w-full mb-4 pb-4 border-b">
// //           <label
// //             htmlFor={"fontColor"}
// //             className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
// //             <p className="w-full font-bold">Betű szín: </p>
// //             <span className="w-full text-sm text-gray-600 whitespace-pre-line">
// //               Válassza ki, hogy milyen színű legyen a cím elem -
// //               (alapértelmezett érték: #212121 - Fekete).
// //             </span>
// //           </label>

// //           <div className="w-3/4 flex flex-row justify-center align-center">
// //             <ColorPicker value={color} onChange={setColor} />
// //           </div>
// //         </div>
// //         {/* title position */}
// //         <div className="flex flex-row w-full mb-4 pb-4 border-b">
// //           <label
// //             htmlFor={"titlePosition"}
// //             className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
// //             <p className="w-full font-bold">Cím elhelyezkedése: </p>
// //             <span className="w-full text-sm text-gray-600 whitespace-pre-line">
// //               Válassza ki, hogy a cím elem a tartalmazó dobozban milyen
// //               pozícióban helyezkedjen el - (alapértelmezett érték: Relatív).
// //             </span>
// //           </label>

// //           <Select
// //             options={initialData.editor.title.titlePosition}
// //             className="w-3/4"
// //             placeholder={"Válasszon cím pozíciót"}
// //             backspaceRemovesValue={false}
// //             name={"titlePosition"}
// //             menuPosition={"fixed"}
// //             ref={(r) => (inputRefs.current[index++] = r)}
// //             defaultValue={
// //               content?.titlePosition
// //                 ? initialData.editor.title.titlePosition.find(
// //                     (x) => x.value === content.titlePosition
// //                   )
// //                 : initialData.editor.title.titlePosition[0]
// //             }
// //             onChange={(val, e) => {
// //               // second parameter shows action triggered
// //               // dispatch(selectParentPage({ parent: val }));
// //             }}
// //             required
// //           />
// //         </div>
// //         {/* title top right bottom left - % */}
// //         <div className="flex flex-row w-full mb-4 pb-4 border-b">
// //           <label
// //             htmlFor={"titleDistance"}
// //             className="w-1/4 text-normal text-gray-400 whitespace-pre flex-flex-col flex-wrap pr-2">
// //             <p className="w-full font-bold">Cím távolsága: </p>
// //             <span className="w-full text-sm text-gray-600 whitespace-pre-line">
// //               Válassza ki, hogy a cím elem a tartalmazó dobozban - a doboz négy
// //               sarkától milyen távolságra helyezkedjen el %-ban -
// //               (alapértelmezett érték: 0 0 0 0).
// //             </span>
// //           </label>

// //           <div className="flex flex-row flex-nowrap justify-evenly items-center">
// //             <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
// //               <span className="fill-gray-600 w-[2.5rem] h-[2.5rem]">
// //                 {icons.up}
// //               </span>
// //               <input
// //                 type="text"
// //                 name="titlePositionTop"
// //                 id="titlePositionTop"
// //                 ref={(r) => (inputRefs.current[index++] = r)}
// //                 className="w-3/4 border h-max p-2"
// //                 defaultValue={content?.titlePositionTop ?? 0}
// //               />
// //             </div>
// //             <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
// //               <span className="fill-gray-600 w-[2.5rem] h-[2.5rem]">
// //                 {icons.right}
// //               </span>
// //               <input
// //                 type="text"
// //                 name="titlePositionRight"
// //                 id="titlePositionRight"
// //                 ref={(r) => (inputRefs.current[index++] = r)}
// //                 className="w-3/4 border h-max p-2"
// //                 defaultValue={content?.titlePositionRight ?? 0}
// //               />
// //             </div>
// //             <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
// //               <span className="fill-gray-600 w-[2.5rem] h-[2.5rem]">
// //                 {icons.down}
// //               </span>
// //               <input
// //                 type="text"
// //                 name="titlePositionBottom"
// //                 id="titlePositionBottom"
// //                 ref={(r) => (inputRefs.current[index++] = r)}
// //                 className="w-3/4 border h-max p-2"
// //                 defaultValue={content?.titlePositionBottom ?? 0}
// //               />
// //             </div>
// //             <div className="flex flex-row flex-nowrap w-1/4 justify-evenly items-center max-h-10">
// //               <span className="fill-gray-600 w-[2.5rem] h-[2.5rem]">
// //                 {icons.left}
// //               </span>
// //               <input
// //                 type="text"
// //                 name="titlePositionLeft"
// //                 id="titlePositionLeft"
// //                 ref={(r) => (inputRefs.current[index++] = r)}
// //                 className="w-3/4 border h-max p-2"
// //                 defaultValue={content?.titlePositionLeft ?? 0}
// //               />
// //             </div>
// //           </div>
// //         </div>
// //         {/* title position alignment - top right bottom left - transform(translate(-x, -y))  */}
// //       </div>
// //       <ModalButton
// //         disabled={!titleText}
// //         btntext={"Mentés"}
// //         callback={submitTitle}
// //       />
// //     </div>
// //   );
// // };

// // export default Title;
