import React, { useCallback } from "react";
import { useSelector, useDispatch } from "react-redux";
import { clickedElementBox } from "@/store/slices/pageEditorSlice";
import useDynamicManager from "@/store/managers/useDynamicManager";

const AddColumnElement = ({ parent, index, toggleModal, type }) => {
  const boxList = useSelector((state) => state.pageEditor.data);
  const { state, setSelectCurrentElement } = useDynamicManager(type);
  const dispatch = useDispatch();

  const handleClickedPosition = useCallback(
    (e) => {
      let clickedColumnBox = 0;
      const parentIndex = e.target.dataset.index;
      const columnIndex = e.target.dataset.innerIndex;
      state?.containerData?.map((b, i) => {
        b?.content?.map((c, i) => {
          if (
            parseInt(c.parentId) === parseInt(parentIndex) &&
            parseInt(c.innerId) === parseInt(columnIndex)
          ) {
            clickedColumnBox = c.content.length;
          }
        });
      });

      setSelectCurrentElement({
        clickedBox: {
          parentId: e.target.dataset.index,
          innerId: e.target.dataset.innerIndex,
          innerElementIndex: clickedColumnBox,
          content: [],
        },
      });
    },
    [setSelectCurrentElement, state]
  );

  return (
    <div
      className="element--add w-auto flex flex-col text-center m-4 p-2 justify-center items-center border border-dashed border-gray-700/25 cursor-pointer pointer-events-auto m-1 hover:border-gray-700"
      onClick={(e) => {
        toggleModal("showSelectElementModal");
        handleClickedPosition(e);
      }}
      data-index={parent}
      data-inner-index={index}>
      <p className="pointer-events-none">+ Elem hozzáadása</p>
    </div>
  );
};

export default AddColumnElement;
