import React, { useCallback, useState } from "react";
import ColumnElementOption from "../columnelementoption/ColumnElementOption";
import SafeHTML from "@/components/shared/safehtml/safeHTML";
import icons from "@/assets/icons/icons";
import { useModalManager } from "@/hooks/useModalManager";
import Modal from "@/components/shared/modal/Modal";
import selectableElementsData from "@/data/selectableElementsData";
import ColumnElements from "../columnelements/ColumnElements";
import useElementActions from "@/hooks/useElementActions";
import useDynamicManager from "@/store/managers/useDynamicManager";

const ColumnContent = ({
  data,
  alldata,
  parent,
  index,
  type,
  lifecycleHandlers,
}) => {
  const {
    state,
    setSelectedImage,
    setEditedElement,
    resetImageState,
    resetSliderState,
    resetGalleryState,
    resetCurrent,
  } = useDynamicManager(type);

  const { toggleModal, isModalOpen } = useModalManager();

  const [elementToRemove, setElementToRemove] = useState(null);

  const {
    handleRemoveElement,
    handleUpdateColumnElementOrder,
    handleMoveColumnElement,
    handleCloneElement,
  } = useElementActions(toggleModal);

  const editSelectedElement = useCallback(
    (e) => {
      const { type, index, innerIndex, innerElementIndex } =
        e.currentTarget.dataset;
      const modalName = `${type}-${parent}-${innerIndex}-${innerElementIndex}`;
      const onOpen = lifecycleHandlers[type]?.onOpen;
      onOpen?.();
      toggleModal(modalName);
      console.log("modalname", modalName, "dataset", e.currentTarget.dataset);

      if (type === "image") {
        const img =
          state?.containerData?.[index]?.content?.[innerIndex]?.content?.[
            innerElementIndex
          ]?.content?.[0]?.image;
        if (img) setSelectedImage({ selectedImage: img });
      } else {
        resetImageState();
      }

      setEditedElement({
        editContent: {
          parentId: index,
          innerId: innerIndex,
          innerElementIndex,
          content: [
            state?.containerData?.[index]?.content?.[innerIndex]?.content?.[
              innerElementIndex
            ],
          ],
        },
      });
    },
    [state, toggleModal]
  );

  const handleRemoveElementClick = () => {
    if (!elementToRemove) return;
    handleRemoveElement(
      elementToRemove.parentId,
      elementToRemove.innerId,
      elementToRemove.innerElementIndex
    );
    toggleModal("deleteElementConsent");
    setElementToRemove(null);
  };

  if (parseInt(data?.parentId) !== parent || parseInt(data?.innerId) !== index)
    return null;

  return (
    <>
      {data.content.map((c, i) => {
        const modalSuffix = `${parent}-${index}-${c.innerElementIndex}`;
        const elements = selectableElementsData(
          state?.current,
          toggleModal,
          type,
          lifecycleHandlers,
          { parent, index, innerElementIndex: c.innerElementIndex }
        );

        return (
          <div key={i} className="flex flex-col items-center mx-4">
            {/* Controls */}
            <div className="w-full flex justify-between items-center bg-[#F7F7F7] border-y border-[#dedede]">
              <div className="flex items-center">
                <ColumnElementOption
                  icon={icons.trash}
                  handleClick={() => {
                    toggleModal("deleteElementConsent");
                    setElementToRemove({
                      parentId: parent,
                      innerId: index,
                      innerElementIndex: c.innerElementIndex,
                    });
                  }}
                />
                {/* Up/down inside column */}
                {data.content.length > 1 && (
                  <>
                    {c.innerElementIndex > 0 && (
                      <ColumnElementOption
                        icon={icons.up}
                        handleClick={() =>
                          handleUpdateColumnElementOrder(
                            parent,
                            index,
                            c.innerElementIndex,
                            "down"
                          )
                        }
                      />
                    )}
                    {c.innerElementIndex < data.content.length - 1 && (
                      <ColumnElementOption
                        icon={icons.down}
                        handleClick={() =>
                          handleUpdateColumnElementOrder(
                            parent,
                            index,
                            c.innerElementIndex,
                            "up"
                          )
                        }
                      />
                    )}
                  </>
                )}
              </div>

              {/* Left/right between columns */}
              <div className="flex items-center">
                {index > 0 && (
                  <ColumnElementOption
                    icon={icons.left}
                    handleClick={() =>
                      handleMoveColumnElement(parent, index, i, "left")
                    }
                  />
                )}
                {index < alldata.length - 1 && (
                  <ColumnElementOption
                    icon={icons.right}
                    handleClick={() =>
                      handleMoveColumnElement(parent, index, i, "right")
                    }
                  />
                )}
              </div>

              {/* Clone */}
              <div className="flex items-center">
                <ColumnElementOption
                  icon={icons.clone}
                  handleClick={() =>
                    handleCloneElement(parent, index, c.innerElementIndex)
                  }
                />
              </div>
            </div>

            {/* Element preview (click to edit) */}
            <div
              className="w-full p-2 bg-white uppercase font-bold cursor-pointer border border-dashed border-gray-300 hover:border-gray-600 mb-2"
              data-type={c.content[0]?.type}
              data-index={parent}
              data-inner-index={index}
              data-inner-element-index={c.innerElementIndex}
              onClick={(e) => editSelectedElement(e, c)}>
              {c.content[0]?.type || "N/A"}
              <SafeHTML
                cls="text-[0.85rem] font-normal"
                content={
                  c.content[0]?.titleTextContent ||
                  c.content[0]?.textContent ||
                  c.content[0]?.buttonText ||
                  c.content[0]?.selectedProduct?.productGroupTitle ||
                  c.content[0]?.selectedArticle?.articleTitle ||
                  c.content[0]?.selectedColumnLabel ||
                  c.content[0]?.selectedCategory
                }
              />
            </div>

            {/* Element-specific modals */}
            <ColumnElements
              elements={elements}
              toggleModal={toggleModal}
              isModalOpen={isModalOpen}
              type={type}
              lifecycleHandlers={lifecycleHandlers}
              modalSuffix={modalSuffix}
            />
          </div>
        );
      })}

      {/* Delete confirmation modal */}
      <Modal
        title={`Biztosan szeretné eltávolítani ezt az elemet? <span style="width: 100%">A művelet nem vonható vissza!</span>`}
        show={isModalOpen("deleteElementConsent")}
        onClose={() => toggleModal("deleteElementConsent")}
        width="auto">
        <div className="flex justify-evenly">
          <button
            className="px-4 py-2 text-white bg-red-500 hover:bg-red-500/50"
            onClick={handleRemoveElementClick}>
            Törlés
          </button>
          <button
            className="px-4 py-2 text-black bg-gray-100 hover:bg-gray-100/50"
            onClick={() => toggleModal("deleteElementConsent")}>
            Mégsem
          </button>
        </div>
      </Modal>
    </>
  );
};

export default ColumnContent;
