import ColumnElementOption from "./ColumnElementOption";
import useDynamicManager from "@/store/managers/useDynamicManager";
import icons from "@/assets/icons/icons";
const ElementControls = ({
  c,
  index,
  currentData,
  parent,
  alldata,
  dispatch,
  type,
}) => {
  const {
    removeElement,
    updateColumnElementOrder,
    moveColumnElement,
    cloneElement,
  } = useDynamicManager(type);
  const isFirst = c.innerElementIndex === 0;
  const isLast = c.innerElementIndex === currentData?.content?.length - 1;

  return (
    <div className="flex flex-row justify-between items-center w-full bg-white border-y border-[#dedede]">
      {/* Left: Remove / Order controls */}
      <div className="flex items-center gap-1">
        <ColumnElementOption
          data-index={parent}
          data-inner-index={index}
          data-inner-element-index={c?.innerElementIndex}
          icon={icons.trash}
          handleClick={() =>
            removeElement({
              parentId: parent,
              innerId: index,
              innerElementIndex: c.innerElementIndex,
            })
          }
        />
        {/* Order: Up/Down */}
        {!isFirst && (
          <ColumnElementOption
            icon={icons.up}
            handleClick={() =>
              updateColumnElementOrder({
                parentId: parent,
                innerId: index,
                innerElementIndex: c.innerElementIndex,
                start: c.innerElementIndex - 1,
                end: c.innerElementIndex,
              })
            }
          />
        )}
        {!isLast && (
          <ColumnElementOption
            icon={icons.down}
            handleClick={() =>
              updateColumnElementOrder({
                parentId: parent,
                innerId: index,
                innerElementIndex: c.innerElementIndex,
                start: c.innerElementIndex + 1,
                end: c.innerElementIndex,
              })
            }
          />
        )}
      </div>

      {/* Middle: Move left/right between columns */}
      <div className="flex items-center gap-2">
        {index > 0 && (
          <ColumnElementOption
            icon={icons.left}
            handleClick={() =>
              moveColumnElement({
                parentId: parent,
                innerId: index,
                innerElementIndex: c.innerElementIndex,
                newColumnIndex: index - 1,
              })
            }
          />
        )}
        {index < alldata?.content?.length - 1 && (
          <ColumnElementOption
            icon={icons.right}
            handleClick={() =>
              moveColumnElement({
                parentId: parent,
                innerId: index,
                innerElementIndex: c.innerElementIndex,
                newColumnIndex: index + 1,
              })
            }
          />
        )}
      </div>

      {/* Right: Clone */}
      <div className="flex items-center">
        <ColumnElementOption
          icon={icons.clone}
          handleClick={() =>
            cloneElement({
              parentId: parent,
              innerId: index,
              innerElementIndex: c.innerElementIndex,
            })
          }
        />
      </div>
    </div>
  );
};

export default ElementControls;
