import React, { useState } from "react";
import useContainerTitle from "@/hooks/useContainerTitle";
import ContainerOptionsLayout from "./containeroptions/ContainerOptionsLayout";
import { useModalManager } from "@/hooks/useModalManager";
import { useSelector, useDispatch } from "react-redux";
import Column from "../column/Column";

const Container = ({ data, alldata, parent, handleTitleChange, type }) => {
  const [showContainerContent, setShowContainerContent] = useState(true);
  const containerTitle = useContainerTitle(parent, data);
  const { toggleModal, isModalOpen } = useModalManager();
  return (
    <div className="flex flex-row w-auto border my-2 shadow-md">
      <div className="flex flex-wrap w-full border" data-index={parent}>
        <div className="w-full bg-[#198fd9] flex justify-between items-center">
          <input
            type="text"
            placeholder="Konténer"
            onChange={(e) =>
              handleTitleChange({ parentId: parent, title: e.target.value })
            }
            className="px-2 py-1 mx-2 outline-none"
            defaultValue={containerTitle?.text || ""}
          />
          <ContainerOptionsLayout
            alldata={alldata}
            toggleModal={toggleModal}
            isModalOpen={isModalOpen}
            showContainerContent={showContainerContent}
            setShowContainerContent={() =>
              setShowContainerContent((prev) => !prev)
            }
            parent={parent}
            type={type}
          />
        </div>
        {showContainerContent && (
          <div className="flex flex-wrap w-full justify-between px-2 py-4">
            {data.size?.map((c, idx) => (
              <Column
                key={idx}
                data={c}
                alldata={data.content}
                parent={parent}
                index={idx}
                type={type}
              />
            ))}
          </div>
        )}
      </div>
    </div>
  );
};

export default Container;
