import React, { useCallback, useState } from "react";
import { useSelector, useDispatch } from "react-redux";
import ContainerOption from "./ContainerOption";
// import useContainerActions from "@/hooks/useContainerActions";
import { useModalManager } from "@/hooks/useModalManager";
import usePageEditorManager from "@/store/managers/usePageEditorManager";
import Modal from "@/components/shared/modal/Modal";
import { initialData } from "@/data/data";
import icons from "@/assets/icons/icons";
import { usePageEditorContextManager } from "@/context/PageEditorContext";
import useDynamicManager from "@/store/managers/useDynamicManager";
import useContainerActions from "@/hooks/useContainerActions";
import useColumnActions from "@/hooks/useColumnActions";
import ContainerSettings from "../containersettings/ContainerSettings";

const ContainerOptionsLayout = ({
  showContainerContent,
  setShowContainerContent,
  parent,
  type,
  lifecycleHandlers,
}) => {
  const { boxColumnsList } = usePageEditorContextManager();
  const { toggleModal, isModalOpen } = useModalManager();

  const {
    state,
    addColumn,
    removeContainer,
    cloneContainer,
    updateContainerOrder,
    setSelectedContainer,
  } = useDynamicManager(type);

  const {
    handleRemoveContainer,
    handleEditContainerOptions,
    cloneSelectedContainer,
  } = useContainerActions(initialData, toggleModal, type);

  const { handleAddColumn } = useColumnActions(parent, type, toggleModal);

  return (
    <>
      <div className="w-max flex flex-row justify-between text-white items-center">
        {/* edit container */}
        <ContainerOption
          handleOnClick={(e) => handleEditContainerOptions(e)}
          parent={parent}
          icon={icons.edit}
        />
        {/* add column */}
        <ContainerOption
          handleOnClick={() => toggleModal("containerModal")}
          parent={parent}
          icon={icons.add}
        />
        {/* clone container */}
        <ContainerOption
          handleOnClick={() => cloneSelectedContainer(parent)}
          parent={parent}
          icon={icons.copy}
        />
        {/* move container */}
        {parent != 0 && parent !== state.containerData?.length - 1 ? (
          <>
            <ContainerOption
              handleOnClick={() =>
                updateContainerOrder({
                  parentId: parent,
                  start: parent - 1,
                  end: parent,
                })
              }
              parent={parent}
              icon={icons.up}
            />
            <ContainerOption
              handleOnClick={() =>
                updateContainerOrder({
                  parentId: parent,
                  start: parent + 1,
                  end: parent,
                })
              }
              parent={parent}
              icon={icons.down}
            />
          </>
        ) : parent === 0 && state.containerData?.length === 1 ? (
          <></>
        ) : parent === 0 && state.containerData?.length > 1 ? (
          <ContainerOption
            handleOnClick={() => {
              updateContainerOrder({
                parentId: parent,
                start: parent + 1,
                end: parent,
              });
            }}
            parent={parent}
            icon={icons.down}
          />
        ) : (
          parent === state.containerData?.length - 1 && (
            <ContainerOption
              handleOnClick={() =>
                updateContainerOrder({
                  parentId: parent,
                  start: parent - 1,
                  end: parent,
                })
              }
              parent={parent}
              icon={icons.up}
            />
          )
        )}
        {/* remove container */}
        <ContainerOption
          handleOnClick={() => toggleModal("deleteContainerConsent")}
          parent={parent}
          icon={icons.trash}
        />
        {/* hide container */}
        <div className="ml-10">
          <ContainerOption
            handleOnClick={setShowContainerContent}
            parent={parent}
            icon={showContainerContent ? icons.chevronDown : icons.chevronUp}
          />
        </div>
      </div>
      {/* box columns */}
      <Modal
        title={"Válasszon az alábbi elemek közül"}
        show={isModalOpen("containerModal")}
        onClose={() => toggleModal("containerModal")}
        height={"100%"}>
        <div className="grid grid-cols-6 gap-4 my-6">
          {boxColumnsList?.columnList?.map((c, i) => (
            <div
              key={i}
              className="border border-dashed border-gray-400 hover:border-gray-700 p-2 cursor-pointer"
              onClick={() => {
                handleAddColumn(c.columnSize);
              }}>
              <div className="grid w-full grid-cols-1 sm:grid-cols-2 md:grid-cols-12 gap-1">
                {c?.columnSize?.map((col, idx) => {
                  const colX = parseInt(col.x, 10);
                  const colY = parseInt(col.y, 10);
                  const colSpan = Math.round((colX / colY) * 12); // Tailwind's 12-col grid

                  return (
                    <div
                      key={idx}
                      className={`bg-gray-500 text-white text-xs grid justify-center items-center h-20 gap-1 col-span-${colSpan}`}>
                      {colX}/{colY}
                    </div>
                  );
                })}
              </div>
            </div>
          ))}
        </div>
        {/* <div className="flex flex-row flex-wrap justify-evenly">
          {boxColumnsList?.columnList?.map((c, i) => {
            return (
              <div
                key={i}
                className="flex flex-row flex-nowrap mx-px my-4 w-1/6 border pointer-events-auto justify-between items-center border border-dashed border-gray-500/25 hover:border-gray-500 hover:cursor-pointer"
                onClick={() => {
                  addColumn({ parentId: parent, sizes: c.columnSize });
                  toggleModal("containerModal");
                }}>
                <div className="flex flex-row flex-nowrap w-full m-1 pointer-events-none">
                  {c?.columnSize?.map((col, idx) => {
                    const colX = col.x;
                    const colY = col.y;

                    return (
                      <div
                        key={idx}
                        className={`h-20 flex flex-row flex-nowrap justify-center items-center border p-2 bg-gray-400`}
                        style={{
                          width: `${((colX / colY) * 100).toFixed(0) - 1}%`,
                        }}>
                        <p className="w-full flex flex-row justify-center items-center text-white text-sm">{`${colX}/${colY}`}</p>
                      </div>
                    );
                  })}
                </div>
              </div>
            );
          })}
        </div> */}
      </Modal>
      {/* yes/no */}
      <Modal
        title={`Biztosan szeretné eltávolítani ezt a konténert? <span style="width: 100%">A művelet nem vonható vissza!</span>`}
        show={isModalOpen("deleteContainerConsent")}
        onClose={() => toggleModal("deleteContainerConsent")}
        width="max-content">
        <div className="flex flex-row flex-wrap justify-evenly h-max">
          <button
            className="px-4 py-2 border border-gray-200 text-white hover:bg-red-500/50 bg-red-500"
            onClick={() => handleRemoveContainer(parent)}>
            Törlés
          </button>
          <button
            className="px-4 py-2 border border-gray-200 text-black hover:bg-gray-100/50 bg-gray-100"
            onClick={() => toggleModal("deleteContainerConsent")}>
            Mégsem
          </button>
        </div>
      </Modal>
      <Modal
        title={"Konténer beállításai"}
        show={isModalOpen("container-options")}
        onClose={() => toggleModal("container-options")}
        height={"100%"}>
        <ContainerSettings
          parent={parent}
          setShowColumnSettings={() => toggleModal("container-options")}
          toggleModal={toggleModal}
          modalName={"container-options"}
          type={type}
          lifecycleHandlers={lifecycleHandlers}
        />
      </Modal>
    </>
  );
};

export default ContainerOptionsLayout;
