import React, { useEffect, useState } from "react";
import ContainerOptionsLayout from "../container/containeroptions/ContainerOptionsLayout";
import PageBoxSizes from "./PageBoxSizes";
import useContainerTitle from "@/hooks/useContainerTitle";
import useDynamicManager from "@/store/managers/useDynamicManager";

const PageBoxList = ({ data, alldata, parent, type }) => {
  const [showContainerContent, setShowContainerContent] = useState(true);
  const [title, setTitle] = useState(data?.title || "");
  const { state, setContainerTitle } = useDynamicManager(type);

  const container = state.containerData?.[parent];

  return (
    <div className="flex flex-row w-auto border my-2 shadow-md">
      <div className="flex flex-wrap w-full border" data-index={parent}>
        <div className="w-full bg-[#198fd9] flex justify-between items-center">
          <input
            type="text"
            placeholder="Konténer"
            onChange={(e) =>
              setContainerTitle({ parentId: parent, title: e.target.value })
            }
            className="px-2 py-1 mx-2 outline-none"
            value={state.containerData?.[parent]?.title || ""}
          />
          <ContainerOptionsLayout
            alldata={container}
            parent={parent}
            showContainerContent={showContainerContent}
            setShowContainerContent={() =>
              setShowContainerContent((prev) => !prev)
            }
            type={type}
          />
        </div>
        {showContainerContent && (
          <div className="grid w-full grid-cols-1 sm:grid-cols-2 md:grid-cols-12 gap-1 justify-center px-2 py-4">
            {container.size?.map((c, idx) => (
              <PageBoxSizes
                key={`${parent}-${idx}`}
                data={c}
                alldata={container}
                parent={parent}
                index={idx}
                type={type}
              />
            ))}
          </div>
        )}
      </div>
    </div>
  );
};

export default PageBoxList;
