import React, { useState, useEffect, useCallback } from "react";
import useColumnSize from "@/hooks/useColumnSize";
import useDynamicManager from "@/store/managers/useDynamicManager";
import { usePageEditorContextManager } from "@/context/PageEditorContext";
import { buildColumnSizeList } from "@/utils/buildColumnSizeList";
import ColumnOptionsLayout from "@/components/editor/column/columnoptions/ColumnOptionsLayout";
import PageBoxContent from "./PageBoxContent";
import { useModalManager } from "@/hooks/useModalManager";
import Modal from "@/components/shared/modal/Modal";
import EditorGallery from "@/components/editor-elements/EditorGallery/EditorGallery";
import EditorProductGallery from "@/components/editor-elements/EditorProductGallery/EditorGallery";

const PageBoxSizes = ({ data, alldata, index, parent, type }) => {
  const { column, colSize, setColSize } = useColumnSize(data);
  const { boxColumnsList } = usePageEditorContextManager();
  const [filteredSizes, setFilteredSizes] = useState(null);
  const { toggleModal, isModalOpen } = useModalManager();
  const {
    state,
    changeColumnSize,
    removeColumn,
    updateColumnOrder,
    selectedElement,
  } = useDynamicManager(type);
  const container = state.containerData?.[parent];

  useEffect(() => {
    const sizeList = [];

    boxColumnsList?.columnList?.map((col) => {
      if (col) {
        sizeList.push({ id: col._id, sizes: col.columnSize });
      }
    });
    const filteredSizeList = buildColumnSizeList(
      sizeList,
      boxColumnsList?.columnList
    );

    setFilteredSizes(filteredSizeList);
  }, [boxColumnsList?.columnList]);

  const colSpan = Math.round((column / 100) * 12);

  const handleEditElement = useCallback(
    (e) => {
      const { type, index, innerIndex, innerElementIndex } = e.target.dataset;

      const elementData =
        state.containerData?.[index]?.content?.[innerIndex]?.content?.[
          innerElementIndex
        ];

      if (!elementData) return;

      // Dispatch selected element to Redux
      selectedElement({
        parentId: index,
        innerId: innerIndex,
        innerElementIndex,
        content: elementData,
      });

      // Optional: open type-based modal if needed
      switch (type) {
        case "gallery":
          toggleModal("gallery");
          break;
        case "product-gallery":
          toggleModal("product-gallery");
          break;
        default:
          break;
      }
    },
    [state.containerData, selectedElement, toggleModal]
  );

  return (
    <div className={`col-span-${colSpan} h-auto border`}>
      <div className="w-full min-h-[8rem]">
        <div className="flex flex-col justify-start bg-white relative border-t mb-4">
          <ColumnOptionsLayout
            data={data}
            alldata={container}
            parent={parent}
            index={index}
            type={type}
          />
          {container?.content?.map((col, idx) => {
            return (
              col?.content?.length > 0 &&
              parseInt(col?.innerId) === parseInt(index) && (
                <PageBoxContent
                  key={idx}
                  data={col}
                  alldata={container}
                  parent={parent}
                  index={index}
                  type={type}
                  editSelectedElement={handleEditElement}
                />
              )
            );
          })}
        </div>
      </div>

      <Modal
        title={"Termék Galéria hozzáadása"}
        show={isModalOpen("product-gallery")}
        onClose={() => toggleModal("product-gallery")}
        height={"100%"}>
        <EditorProductGallery
          setShowEditorGalleryModal={() => toggleModal("gallery")}
          data={selectedElement}
          type={type}
        />
      </Modal>
      <Modal
        title={"Galéria hozzáadása"}
        show={isModalOpen("gallery")}
        onClose={() => toggleModal("gallery")}
        height={"100%"}>
        <EditorGallery
          setShowEditorGalleryModal={() => toggleModal("gallery")}
          data={selectedElement}
          type={type}
        />
      </Modal>
    </div>
  );
};

export default PageBoxSizes;
