import React from "react";
import Input from "@/components/shared/input/Input";
import {
  VALIDATOR_REQUIRE,
  VALIDATOR_MINLENGTH,
  VALIDATOR_MAXLENGTH,
} from "@/utils/validators";

const PageEditorFormFields = ({ data, handleInput, initialValid }) => {
  return (
    <>
      <Input
        element="input"
        id="pageTitle"
        type="text"
        name="pageTitle"
        placeholder="Oldal név"
        inputcls="w-full border-1 text-center p-2 my-2 outline-blue-500"
        className="w-100"
        validators={[
          VALIDATOR_REQUIRE(),
          VALIDATOR_MINLENGTH(2),
          VALIDATOR_MAXLENGTH(254),
        ]}
        errorText={"Nem lehet üres"}
        onInput={handleInput}
        initialValid
        value={data?.pageTitle?.value}
      />
      <Input
        element="input"
        type="text"
        id="pageSlug"
        name="pageSlug"
        placeholder="Oldal url"
        className="w-100"
        inputcls="w-full border-1 text-center p-2 my-2 bg-gray-100 outline-gray-100"
        errorText={"Not valid url"}
        onInput={handleInput}
        initialValid={true}
        value={data?.pageSlug?.value}
        readOnly
      />
      <Input
        element="input"
        id="pageLink"
        type="text"
        name="pageLink"
        placeholder="Oldal link"
        inputcls="w-full border-1 text-center p-2 my-2 outline-blue-500"
        className="w-100"
        onInput={handleInput}
        initialValid={true}
        value={data?.pageLink?.value}
      />
      {/* seo title */}
      <Input
        element="input"
        type="text"
        id="pageSeoTitle"
        name="pageSeoTitle"
        placeholder="Oldal SEO cím"
        className="w-100"
        inputcls="w-full border-1 text-center p-2 my-2"
        errorText={"Not valid url"}
        onInput={handleInput}
        initialValid={true}
        value={data?.pageSeoTitle?.value ?? ""}
      />
      {/* page link title */}
      <Input
        element="input"
        type="text"
        id="pageLinkTitle"
        name="pageLinkTitle"
        placeholder="Oldal link title"
        className="w-100"
        inputcls="w-full border-1 text-center p-2 my-2"
        errorText={"Not valid url"}
        onInput={handleInput}
        initialValid={true}
        value={data?.pageLinkTitle?.value ?? ""}
      />
      {/* page seo description */}
      <Input
        element="textarea"
        type="text"
        id="pageMetaDescription"
        name="pageMetaDescription"
        placeholder="Oldal meta leírás"
        className="w-100"
        inputcls="w-full border-1 text-center p-2 my-2"
        errorText={"Not valid url"}
        onInput={handleInput}
        initialValid={true}
        value={data?.pageMetaDescription?.value || ""}
      />
    </>
  );
};

export default PageEditorFormFields;
