// ExpandedRowTabs.jsx
import React from "react";

const ExpandedRowTabs = ({ activeTab, onTabChange }) => {
  return (
    <div className="flex w-full border-b mb-4 text-[0.85rem]">
      <button
        onClick={() => onTabChange(1)}
        className={`px-4 py-1 border-t border-r border-l border-gray-200 cursor-pointer ${
          activeTab === 1 ? "bg-green-500 text-white" : ""
        }`}>
        Iktatás adatok
      </button>
      <button
        onClick={() => onTabChange(2)}
        className={`px-4 py-1 border-t border-r border-gray-200 cursor-pointer ${
          activeTab === 2 ? "bg-green-500 text-white" : ""
        }`}>
        Díjbekérő/Előlegszámla
      </button>
      <button
        onClick={() => onTabChange(3)}
        className={`px-4 py-1 border-t border-r border-gray-200 cursor-pointer ${
          activeTab === 3 ? "bg-green-500 text-white" : ""
        }`}>
        Számla
      </button>
      <button
        onClick={() => onTabChange(4)}
        className={`px-4 py-1 border-t border-r border-gray-200 cursor-pointer ${
          activeTab === 4 ? "bg-green-500 text-white" : ""
        }`}>
        Végszámla
      </button>
    </div>
  );
};

export default ExpandedRowTabs;
