// src/components/hr/PersonDocument.tsx
"use client";

import dynamic from "next/dynamic";
const SunEditor = dynamic(() => import("suneditor-react"), { ssr: false });
import "suneditor/dist/css/suneditor.min.css";

import React from "react";

type PersonDocumentProps = {
  content: string;
};

const PersonDocument: React.FC<PersonDocumentProps> = ({ content }) => {
  return (
    <SunEditor
      setDefaultStyle="padding: 20px; height: 100%"
      setContents={content}
      readOnly
      hideToolbar
    />
  );
};

export default PersonDocument;

// "use client";

// import dynamic from "next/dynamic";
// const SunEditor = dynamic(() => import("suneditor-react"), { ssr: false });
// import "suneditor/dist/css/suneditor.min.css";

// import React from "react";

// type PersonDocumentProps = {
//   content: string;
// };

// const PersonDocument: React.FC<PersonDocumentProps> = ({ content }) => {
//   return (
//     <SunEditor
//       setDefaultStyle="padding: 20px; height: 100%"
//       setContents={content} // ✅ pass the string, not the whole props object
//       readOnly
//     />
//   );
// };

// export default PersonDocument;
