"use client";

import React, { useState } from "react";
import InventoryElement from "./InventoryElement";
import ApiCall from "@/api/api-calls";
import { toast } from "react-hot-toast";

const InventoryElementCreate = ({ references, onCreated, asset }) => {
  const handleCreate = async (payload) => {
    try {
      const response = await ApiCall.inventory.createAsset(payload);
      toast.success("Eszköz létrehozva");
      onCreated?.(response.data.id);
    } catch (err) {
      toast.error("Létrehozás sikertelen");
    }
  };
  console.log("!!!!", references, asset);
  return (
    <InventoryElement
      asset={asset}
      references={references}
      onRowUpdated={() => {}}
      onSave={handleCreate}
      isCreateMode={true}
    />
  );
};

export default InventoryElementCreate;
