// InventoryLeaseDoc.jsx
import React from "react";
import InventoryRegDocument from "./InventoryRegDocument"; // we reuse its UI
import InventoryLeaseDocument from "./InventoryLeaseDocument";
// This component is just a thin wrapper to pass a different target_column.
const InventoryLeaseDoc = ({ asset, references, onRowUpdated, assetId }) => {
  // any document type will work; we only need target_column
  const dummyTypeId = references.document_types?.[0]?.id ?? null;

  return (
    <InventoryLeaseDocument
      asset={asset}
      references={references}
      onRowUpdated={onRowUpdated}
      assetId={assetId}
      documentTypeId={dummyTypeId}
      // pass through extra props the upload screen forwards to API:
      // ensure your upload API sets target_column if provided
      extraUploadProps={{ target_column: "device_is_leased" }} // 🆕
      titleOverride="Bérleti szerződés"
      readFromColumn="device_is_leased"
    />
  );
};

export default InventoryLeaseDoc;
