import React, { useEffect, useState } from "react";
import ApiCall from "@/api/api-calls";
import { toast } from "react-hot-toast";

const InventoryMovements = ({ assetId }) => {
  const [rows, setRows] = useState([]);
  useEffect(() => {
    (async () => {
      try {
        const res = await ApiCall.inventory.getAssetMovements(assetId);
        setRows(res.data || []);
      } catch {
        toast.error("Mozgástörténet betöltése sikertelen");
      }
    })();
  }, [assetId]);

  return (
    <div className="text-sm overflow-auto">
      <table className="min-w-full border">
        <thead className="bg-gray-100">
          <tr>
            <th className="p-2 border">Dátum</th>
            <th className="p-2 border">Felhasználó</th>
            <th className="p-2 border">Változások</th>
          </tr>
        </thead>
        <tbody>
          {rows.map((r) => (
            <tr key={r.id}>
              <td className="p-2 border">
                {new Date(r.changed_at).toLocaleString()}
              </td>
              <td className="p-2 border">{r.changed_by_username || "–"}</td>
              <td className="p-2 border">
                {(r.changes_pretty || r.changes || []).map?.((c, i) => (
                  <div
                    key={i}
                    className="flex flex-col mb-2 border-t border-t-gray-500">
                    <strong>
                      {c.field === "placed_at"
                        ? "Feltalálási hely"
                        : c.field === "used_at"
                        ? "Felhasználási hely"
                        : c.field === "cost_center"
                        ? "Költséghely"
                        : c.field === "department_id"
                        ? "Szervezeti egység"
                        : c.field === "site_id"
                        ? "Telephely"
                        : c.field}
                      :
                    </strong>
                    <span title={c.old ?? ""}>
                      {c.old_label ?? c.old ?? "∅"}
                      {c.old_label && c.old ? ` (${c.old})` : ""}
                    </span>
                    {"  "}→{"  "}
                    <span title={c.new ?? ""}>
                      {c.new_label ?? c.new ?? "∅"}
                      {c.new_label && c.new ? ` (${c.new})` : ""}
                    </span>
                    {c.old_context || c.new_context ? (
                      <div className="text-xs text-gray-500">
                        {c.old_context && (
                          <span>
                            Régi kontextus: {c.old_context.site || "–"} /{" "}
                            {c.old_context.department || "–"}
                          </span>
                        )}
                        {c.new_context && (
                          <span className="ml-2">
                            Új kontextus: {c.new_context.site || "–"} /{" "}
                            {c.new_context.department || "–"}
                          </span>
                        )}
                      </div>
                    ) : null}
                  </div>
                )) || JSON.stringify(r.changes)}
              </td>
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  );
};

export default InventoryMovements;
