// components/Media/EditMediaModal.jsx
"use client";
import { useEffect, useState } from "react";

const EditMediaModal = ({ image, isOpen, onClose, onSave }) => {
  const [formData, setFormData] = useState({
    original_name: "",
    description: "",
  });

  useEffect(() => {
    if (image) {
      setFormData({
        original_name: image.original_name || "",
        description: image?.props?.description || "",
      });
    }
  }, [image]);

  if (!isOpen) return null;

  const handleChange = (e) =>
    setFormData((prev) => ({ ...prev, [e.target.name]: e.target.value }));

  const handleSubmit = async (e) => {
    e.preventDefault();
    await onSave(formData);
    onClose();
  };

  return (
    <div className="fixed inset-0 z-50 bg-black bg-opacity-30 flex items-center justify-center">
      <div className="bg-white p-6 rounded-lg w-full max-w-md shadow-lg">
        <h3 className="text-lg font-semibold mb-4">
          Kép tulajdonságok szerkesztése
        </h3>

        <form onSubmit={handleSubmit} className="flex flex-col gap-3">
          <input
            type="text"
            name="original_name"
            value={formData.original_name}
            onChange={handleChange}
            className="border rounded px-3 py-2"
            placeholder="Fájlnév"
          />

          <input
            type="text"
            name="description"
            value={formData.description}
            onChange={handleChange}
            className="border rounded px-3 py-2"
            placeholder="Leírás"
          />

          <div className="flex justify-end gap-2 mt-4">
            <button
              type="button"
              onClick={onClose}
              className="px-4 py-2 bg-gray-300 rounded hover:bg-gray-400">
              Mégse
            </button>
            <button
              type="submit"
              className="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">
              Frissítés
            </button>
          </div>
        </form>
      </div>
    </div>
  );
};

export default EditMediaModal;
