"use client";
import SearchInput from "./SearchInput";
import SortSelect from "./SortSelect";
import ItemsPerPageSelect from "./ItemsPerPageSelect";
import DateRangeFilter from "./DateRangeFilter";

const Filters = ({
  searchQuery,
  setSearchQuery,
  sortBy,
  setSortBy,
  sortOrder,
  setSortOrder,
  itemsPerPage,
  setItemsPerPage,
  dateFrom,
  setDateFrom,
  dateTo,
  setDateTo,
  handleResetFilters,
}) => {
  return (
    <div className="flex flex-wrap gap-3 mb-6 items-end">
      <SearchInput
        value={searchQuery}
        onChange={setSearchQuery}
        debounce={300}
      />

      <SortSelect
        sortBy={sortBy}
        setSortBy={setSortBy}
        sortOrder={sortOrder}
        setSortOrder={setSortOrder}
      />

      <ItemsPerPageSelect value={itemsPerPage} onChange={setItemsPerPage} />

      <DateRangeFilter
        dateFrom={dateFrom}
        setDateFrom={setDateFrom}
        dateTo={dateTo}
        setDateTo={setDateTo}
      />

      <button
        type="button"
        onClick={handleResetFilters}
        className="px-4 py-2 bg-gray-300 text-black rounded hover:bg-gray-400 cursor-pointer">
        Szűrők törlése
      </button>
    </div>
  );
};

export default Filters;
