"use client";
import { useEffect, useState } from "react";

const SearchInput = ({ value, onChange, debounce = 300 }) => {
  const [internalValue, setInternalValue] = useState(value);

  useEffect(() => {
    const handler = setTimeout(() => {
      onChange(internalValue);
    }, debounce);
    return () => clearTimeout(handler);
  }, [internalValue]);

  return (
    <input
      type="text"
      placeholder="Keresés..."
      value={internalValue}
      onChange={(e) => setInternalValue(e.target.value)}
      className="px-3 py-2 border border-gray-300 rounded"
    />
  );
};

export default SearchInput;
