"use client";

import Select from "react-select";

export default function OrgCascadingFilters({
  // hooks state
  siteOptions,
  departmentOptions,
  locationOptions,
  siteId,
  setSiteId,
  departmentId,
  setDepartmentId,
  // tie into your page filters
  filters,
  setFilters,
}) {
  const setFilter = (key, val) =>
    setFilters((prev) => ({ ...prev, [key]: val || null }));

  return (
    <>
      <Select
        className="w-auto min-w-72 flex-1 text-left"
        placeholder="Telephely"
        options={siteOptions}
        value={siteOptions.find((o) => o.value === siteId) || null}
        onChange={(opt) => {
          const nextSite = opt?.value || null;
          setSiteId(nextSite);
          setFilter("siteId", nextSite);
          // reset downstream filters on site change
          setDepartmentId(null);
          setFilter("departmentId", null);
          setFilter("placedAtId", null);
          setFilter("usedAtId", null);
        }}
        isClearable
      />

      <Select
        className="w-auto min-w-72 flex-1 text-left"
        placeholder="Szervezeti egység"
        options={departmentOptions}
        value={departmentOptions.find((o) => o.value === departmentId) || null}
        onChange={(opt) => {
          const nextDept = opt?.value || null;
          setDepartmentId(nextDept);
          setFilter("departmentId", nextDept);
          // reset locations when department changes
          setFilter("placedAtId", null);
          setFilter("usedAtId", null);
        }}
        isClearable
        isDisabled={!siteId}
      />

      <Select
        className="w-auto min-w-72 flex-1 text-left"
        placeholder="Feltalálási hely"
        options={locationOptions}
        value={
          locationOptions.find((o) => o.value === filters.placedAtId) || null
        }
        onChange={(opt) => setFilter("placedAtId", opt?.value)}
        isClearable
        isDisabled={!departmentId}
      />

      <Select
        className="w-auto min-w-72 flex-1 text-left"
        placeholder="Felhasználási hely"
        options={locationOptions}
        value={
          locationOptions.find((o) => o.value === filters.usedAtId) || null
        }
        onChange={(opt) => setFilter("usedAtId", opt?.value)}
        isClearable
        isDisabled={!departmentId}
      />
    </>
  );
}
