"use client";
import { useState } from "react";
import toast from "react-hot-toast";
import ApiCall from "@/api/api-calls";

export default function WorkItemCreateModal({
  onClose,
  onCreated,
}: {
  onClose: () => void;
  onCreated: () => void;
}) {
  const [title, setTitle] = useState("");
  const [notes, setNotes] = useState("");
  const [dueAt, setDueAt] = useState("");
  const [busy, setBusy] = useState(false);

  const submit = async () => {
    if (!title.trim()) return toast.error("Hiányzó cím");
    setBusy(true);
    try {
      await ApiCall.qms.createWorkItem({
        title: title.trim(),
        notes: notes.trim() || null,
        dueAt: dueAt || null,
        // optional: objectType/objectId if you want it tied to a doc/version
      });
      toast.success("Work item létrehozva");
      onCreated();
      onClose();
    } catch (e: any) {
      console.error(e);
      toast.error(e?.response?.data?.error ?? "Létrehozás sikertelen");
    } finally {
      setBusy(false);
    }
  };

  return (
    <div className="p-4 space-y-3">
      <div>
        <label className="text-xs text-gray-600">Cím</label>
        <input
          className="w-full border rounded px-3 py-2"
          value={title}
          onChange={(e) => setTitle(e.target.value)}
        />
      </div>

      <div>
        <label className="text-xs text-gray-600">Határidő</label>
        <input
          type="date"
          className="w-full border rounded px-3 py-2"
          value={dueAt}
          onChange={(e) => setDueAt(e.target.value)}
        />
      </div>

      <div>
        <label className="text-xs text-gray-600">Megjegyzés</label>
        <textarea
          className="w-full border rounded px-3 py-2 min-h-[120px]"
          value={notes}
          onChange={(e) => setNotes(e.target.value)}
        />
      </div>

      <div className="flex justify-end gap-2 pt-2 border-t">
        <button
          className="px-3 py-2 rounded border"
          onClick={onClose}
          disabled={busy}>
          Mégse
        </button>
        <button
          className="px-3 py-2 rounded bg-emerald-600 text-white disabled:opacity-60"
          onClick={submit}
          disabled={busy}>
          {busy ? "Mentés…" : "Mentés"}
        </button>
      </div>
    </div>
  );
}
