import { Droppable } from "react-beautiful-dnd";

export const Drop = ({
  id,
  type,
  direction = "vertical",
  isDropDisabled = false,
  isCombineEnabled = false,
  ignoreContainerClipping = false,
  children,
  className,
}) => {
  return (
    <Droppable
      droppableId={id}
      type={type}
      direction={direction}
      isDropDisabled={!!isDropDisabled}
      isCombineEnabled={!!isCombineEnabled}
      ignoreContainerClipping={!!ignoreContainerClipping}>
      {(provided) => (
        <div
          ref={provided.innerRef}
          {...provided.droppableProps}
          className={`flex flex-col gap-2 ${className || ""}`}>
          {children}
          {provided.placeholder}
        </div>
      )}
    </Droppable>
  );
};

// export const Drop = ({
//   id,
//   type,
//   isDropDisabled = false,
//   isCombineEnabled = false,
//   ignoreContainerClipping = false,
//   children,
//   className,
// }) => {
//   return (
//     <Droppable
//       droppableId={id}
//       type={type}
//       isDropDisabled={!!isDropDisabled}
//       isCombineEnabled={!!isCombineEnabled}
//       ignoreContainerClipping={!!ignoreContainerClipping}>
//       {(provided) => (
//         <div
//           ref={provided.innerRef}
//           {...provided.droppableProps}
//           className={className}>
//           {children}
//           {provided.placeholder}
//         </div>
//       )}
//     </Droppable>
//   );
// };

// export const Drop = ({ id, type, ...props }) => {
//   return (
//     <Droppable droppableId={id} type={type}>
//       {(provided) => {
//         return (
//           <div ref={provided.innerRef} {...provided.droppableProps} {...props}>
//             {props.children}
//             {provided.placeholder}
//           </div>
//         );
//       }}
//     </Droppable>
//   );
// };
