"use client";

import { useEffect, useCallback } from "react";

export default function SlideOver({ open, title, onClose, children, footer }) {
  // close on Esc
  const onKeyDown = useCallback(
    (e) => {
      if (e.key === "Escape") onClose?.();
    },
    [onClose]
  );

  useEffect(() => {
    if (!open) return;
    document.addEventListener("keydown", onKeyDown);
    return () => document.removeEventListener("keydown", onKeyDown);
  }, [open, onKeyDown]);

  if (!open) return null;

  return (
    <div className="fixed inset-0 z-50 flex" role="dialog" aria-modal="true">
      {/* Backdrop */}
      <div className="absolute inset-0 bg-black/30 z-40" onClick={onClose} />
      {/* Panel */}
      <div
        className="relative z-50 ml-auto h-full w-full max-w-[860px] bg-white shadow-xl flex flex-col"
        onClick={(e) => e.stopPropagation()}>
        {/* Header */}
        <div className="flex items-center justify-between border-b p-4">
          <h2 className="text-lg font-semibold">{title}</h2>
          <button
            onClick={onClose}
            className="text-sm text-gray-500 hover:text-gray-700">
            Bezár
          </button>
        </div>
        {/* Body */}
        <div className="flex-1 overflow-auto p-4">{children}</div>
        {/* Footer */}
        {footer && <div className="border-t p-3">{footer}</div>}
      </div>
    </div>
  );
}
