import React from "react";
import icons from "@/assets/icons/icons";
import { FilterComponent } from "./FilterComponent";

const TableOptions = ({ url, btnText, onFilter, onClear, filteredText }) => {
  return (
    <div className="flex flex-row justify-center items-center">
      {url && (
        <button
          href={url}
          btntext={btnText}
          className="px-4 py-1 rounded bg-green-600/75 hover:bg-green-600 mr-2 text-white"
        />
      )}
      <FilterComponent
        onFilter={onFilter}
        onClear={onClear}
        filteredText={filteredText}
        icon={icons.clear}
      />
    </div>
  );
};

export default TableOptions;
