import React from "react";
import Button from "../button/Button";

const TableSelectOptions = (props) => {
  const { data, selectedRows, handleDelete, handleSelect } = props;

  return (
    <>
      {data.map((d) => {
        return selectedRows.length === 1 && d.type === "edit" ? (
          <Button
            key={d.text}
            href={d.url + selectedRows[0]._id}
            btntext={d.text}
            className={`${d.className} px-4 py-1 bg-blue-500/75 hover:bg-blue-500`}></Button>
        ) : d.type === "delete" ? (
          <Button
            key={d.text}
            onClick={handleDelete}
            btntext={d.text}
            className={`${d.className} px-4 py-1 bg-red-500/75 hover:bg-red-50`}></Button>
        ) : (
          selectedRows.length === 1 &&
          d.type === "select" && (
            <Button
              key={d.text}
              onClick={() => handleSelect(selectedRows[0])}
              btntext={d.text}
              className={`${d.className} px-4 py-1 bg-red-500/75 hover:bg-red-50`}></Button>
          )
        );
      })}
    </>
  );
};

export default TableSelectOptions;
