// components/EditorToolbar.js
import React from "react";
import { useDispatch } from "react-redux";
import { editorActionMap } from "store/editorActionMap";

const EditorToolbar = ({ editorType = "pageEditor" }) => {
  const dispatch = useDispatch();

  const handleAddContainer = () => {
    const action = editorActionMap[editorType]?.addContainer;
    if (action)
      dispatch(action({ container: { id: Date.now(), content: [] } }));
  };

  const handleClearSelectedImage = () => {
    const action = editorActionMap[editorType]?.clearSelectedImage;
    if (action) dispatch(action());
  };

  const handleResetState = () => {
    const action = editorActionMap[editorType]?.resetState;
    if (action) dispatch(action());
  };

  return (
    <div className="editor-toolbar">
      <button onClick={handleAddContainer}>Add Container</button>
      <button onClick={handleClearSelectedImage}>Clear Selected Image</button>
      <button onClick={handleResetState}>Reset Editor State</button>
    </div>
  );
};

export default EditorToolbar;
