// components/shared/iconPicker/LazyIcon.tsx
"use client";
import React, { useMemo, useState, useEffect } from "react";
import dynamic from "next/dynamic";
import { importIconFromLib } from "@/utils/icon-loader";

const LazyIcon = ({ lib, icon, className = "" }) => {
  const [IconComponent, setIconComponent] = useState(null);

  useEffect(() => {
    let isMounted = true;
    importIconFromLib(lib, icon).then((Component) => {
      if (isMounted) setIconComponent(() => Component);
    });

    return () => {
      isMounted = false;
    };
  }, [lib, icon]);

  return IconComponent ? <IconComponent className={className} /> : null;
};

export default LazyIcon;
