import React, { useEffect, useState } from "react";
import Image from "next/image";

const ImageWithFallback = (props) => {
  const { src, alt, ...rest } = props;
  const [imgSrc, setImgSrc] = useState(src);
  const [imgAlt, setImgAlt] = useState(alt);
  const fallbackSrc = "/no-image-gray.png";

  useEffect(() => {
    setImgSrc(src || "");
  }, [src]);

  useEffect(() => {
    setImgAlt(alt || "");
  }, [alt]);

  return (
    <figure
      className="w-full flex justify-center items-center bg-white border border-gray-300"
      style={{ height: "100%", maxHeight: "250px" }}>
      <Image
        {...rest}
        src={imgSrc}
        alt={imgAlt}
        onError={() => {
          setImgSrc(fallbackSrc);
          setImgAlt("Image placeholder");
        }}
      />
    </figure>
  );
};

export default ImageWithFallback;
