import React from "react";

const FormInput = ({
  id,
  label,
  value,
  type = "text",
  onInput,
  readOnly = false,
}) => (
  <div className="form-input">
    <label htmlFor={id}>{label}</label>
    <input
      id={id}
      name={id}
      type={type}
      value={value}
      onChange={(e) => onInput(e.target.value)}
      readOnly={readOnly}
    />
  </div>
);

export default FormInput;
