import React from "react";

const InputField = ({
  label,
  id,
  description,
  defaultValue,
  inputRefs,
  index,
}) => (
  <div className="flex flex-row w-full mb-4 pb-4 border-b">
    <label htmlFor={id} className="w-1/4 text-gray-400 pr-2">
      <p className="font-bold">{label}</p>
      {description && <p className="text-sm text-gray-600">{description}</p>}
    </label>
    <input
      type="text"
      id={id}
      name={id}
      className="w-3/4 border p-2"
      defaultValue={defaultValue}
      ref={(r) => (inputRefs.current[index.current++] = r)}
    />
  </div>
);

export default InputField;
