const LabeledInput = ({
  label,
  description,
  children,
  contentCls,
  className,
}) => (
  <div className={`${className ?? "flex flex-row w-full mb-4 pb-4 border-b"}`}>
    <label className="w-full text-normal text-gray-400 whitespace-pre-line pr-2">
      <p className="w-full font-bold">{label}</p>
      <span className="w-full text-sm text-gray-600">{description}</span>
    </label>
    <div className={`${contentCls ?? "w-3/4"}`}>{children}</div>
  </div>
);
export default LabeledInput;
