import React from "react";
import icons from "@/assets/icons/icons";
import styles from "./checkbox.module.css";

const FileOption = ({ id, item, index, selectType, checked, handleChange }) => {
  return (
    <div className="flex flex-row flex-nowrap justify-between items-center w-full">
      <label className="flex flex-row justify-center items-center">
        <input
          checked={checked.includes(index)}
          data-index={index}
          type="checkbox"
          onChange={
            selectType === "featured" ||
            selectType === "product-featured" ||
            selectType === "editor-image"
              ? (e) => handleChange(e, item)
              : (e) => handleChange(e, item)
          }
          className={`${styles["checkbox-rounded"]} w-6 h-6 m-2 rounded-full`}
          id={id}
        />
        {checked.includes(index) ? "Kiválasztva" : "Kiválaszt"}
      </label>
      <button
        key={index}
        id={id}
        index={index}
        // onClick={handleModalOpen}
        className="px-2 py-1 fill-green-400 text-white rounded w-[3rem] h-[3rem]">
        {icons.edit}
      </button>
    </div>
  );
};

export default FileOption;
