import React, { useEffect, useState } from "react";
import MediaObject from "../mediaobject/MediaObject";
import ApiCall from "@/api/api-calls";
import Image from "next/image";
import FileOption from "./FileOption";
import Link from "next/link";

const MediaItem = ({ item, index, selectType, checked, handleChange }) => {
  const [src, setSrc] = useState(null);

  useEffect(() => {
    const setImageSrc = async () => {
      const s = ApiCall.mediaStore.getResized("/2/1/0/", item?.originalname);

      setSrc(s);
    };
    setImageSrc();
  }, [item]);

  return (
    <div
      className={`flex flex-col mr-2 mb-2 items-center border border-gray-300 p-2`}
      style={{ minHeight: "250px", width: "100%", maxWidth: "245px" }}
      key={index}>
      {item && src && (
        <>
          {" "}
          {item?.props?.mimetype === "application/pdf" ? (
            <MediaObject
              data={item}
              index={index}
              data-index={index}
              className={"w-full bg-gray-100"}
              id={item._id}
            />
          ) : item?.props?.mimetype ===
            "application/vnd.openxmlformats-officedocument.wordprocessingml.document" ? (
            <div
              className="flex flex-col justify-center items-center cursor-pointer"
              style={{
                minHeight: "150px",
                minWidth: "245px",
                maxWidth: "245px",
              }}>
              <Link
                href={`${process.env.NEXT_PUBLIC_PATH}/static/${item?.props?.dataPath}`}
                target="_blank">
                <p className="flex flex-col justify-center items-center">
                  Word dokumentum <span>{icons.word}</span>
                </p>
              </Link>
            </div>
          ) : item?.props?.mimetype ===
            "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" ? (
            <div
              className="flex flex-col justify-center items-center cursor-pointer"
              style={{
                minHeight: "150px",
                minWidth: "245px",
                maxWidth: "245px",
              }}>
              <Link
                href={`${process.env.NEXT_PUBLIC_PATH}/static/${item?.props?.dataPath}`}
                target="_blank">
                <p className="flex flex-col justify-center items-center">
                  Excel dokumentum
                  <span>{icons.excel}</span>
                </p>
              </Link>
            </div>
          ) : (
            <div
              className="bg-white flex flex-row justify-center items-center"
              style={{
                minHeight: "170px",
                minWidth: "100%",
                maxWidth: "243px",
              }}>
              <Image
                src={src}
                width={245}
                height={150}
                alt={item?.originalname ?? ""}
                style={{
                  objectFit: "contain",
                  width: "100%",
                  height: "100%",
                }}
                effect="blur"
                loading="lazy"
              />
            </div>
          )}
        </>
      )}

      <p className="text-sm text-center font-bold break-all p-1">
        {item?.props?.basename ?? item?.props?.originalname}
      </p>
      <FileOption
        id={item._id}
        selectType={selectType}
        item={item}
        index={index}
        checked={checked}
        handleChange={handleChange}
      />
      {/* <GalleryFileOptions
        id={item._id}
        selectType={selectType}
        item={item}
        handleImageSelect={handleImageSelect}
        checked={checked}
        handleChange={handleChange}
        handleModalOpen={handleModalOpen}
        index={index}
      /> */}
    </div>
  );
};

export default MediaItem;
