import React from "react";
import Link from "next/link";
const MediaObject = ({ data, index, className }) => {
  return (
    <object
      data={`${process.env.NEXT_PUBLIC_PATH}/static/` + data?.props?.dataPath}
      key={index}
      type="application/pdf"
      className={className}
      alt={data.originalname}
      aria-labelledby={data.originalname}>
      <p>
        Alternative text - include a link{" "}
        <Link
          href={
            `${process.env.NEXT_PUBLIC_PATH}/static/` + data?.props?.dataPath
          }>
          to the PDF!
        </Link>
      </p>
    </object>
  );
};

export default MediaObject;
