import React from "react";
import ControlButton from "@/components/shared/button/ControlButton";
import icons from "@/assets/icons/icons";

const OrderControls = ({ index, isFirst, isLast, onOrderChange }) => {
  return (
    <>
      {!isFirst && (
        <ControlButton
          icon={icons.up}
          color="gray"
          hoverColor="green"
          onClick={() => onOrderChange(index - 1, index)}
        />
      )}
      {!isLast && (
        <ControlButton
          icon={icons.down}
          color="gray"
          hoverColor="green"
          onClick={() => onOrderChange(index + 1, index)}
        />
      )}
    </>
  );
};

export default OrderControls;
