import React from "react";
import Select from "react-select";

const SelectField = ({
  label,
  id,
  options,
  selected,
  inputRefs,
  index,
  isMulti = false,
}) => {
  const selectedValue = isMulti
    ? options?.filter((x) => selected?.includes?.(x.value))
    : options?.find((x) => x.value === selected) || null;

  return (
    <div className="flex flex-row w-full mb-4 pb-4 border-b">
      <label htmlFor={id} className="w-1/4 text-gray-400 pr-2">
        <p className="font-bold">{label}</p>
      </label>
      <Select
        inputId={id}
        name={id}
        options={options}
        className="w-3/4"
        menuPosition="fixed"
        backspaceRemovesValue={false}
        isMulti={isMulti}
        value={selectedValue}
        ref={(r) => (inputRefs.current[index.current++] = r)}
      />
    </div>
  );
};

export default SelectField;
